package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SendBulkEmailResponse(
    bulkEmailEntryResults: Iterable[zio.aws.sesv2.model.BulkEmailEntryResult]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.SendBulkEmailResponse = {
    import SendBulkEmailResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.SendBulkEmailResponse
      .builder()
      .bulkEmailEntryResults(bulkEmailEntryResults.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.SendBulkEmailResponse.ReadOnly =
    zio.aws.sesv2.model.SendBulkEmailResponse.wrap(buildAwsValue())
}
object SendBulkEmailResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.SendBulkEmailResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.SendBulkEmailResponse =
      zio.aws.sesv2.model.SendBulkEmailResponse(bulkEmailEntryResults.map {
        item =>
          item.asEditable
      })
    def bulkEmailEntryResults
        : List[zio.aws.sesv2.model.BulkEmailEntryResult.ReadOnly]
    def getBulkEmailEntryResults: ZIO[Any, Nothing, List[
      zio.aws.sesv2.model.BulkEmailEntryResult.ReadOnly
    ]] = ZIO.succeed(bulkEmailEntryResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.SendBulkEmailResponse
  ) extends zio.aws.sesv2.model.SendBulkEmailResponse.ReadOnly {
    override val bulkEmailEntryResults
        : List[zio.aws.sesv2.model.BulkEmailEntryResult.ReadOnly] = impl
      .bulkEmailEntryResults()
      .asScala
      .map { item =>
        zio.aws.sesv2.model.BulkEmailEntryResult.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.SendBulkEmailResponse
  ): zio.aws.sesv2.model.SendBulkEmailResponse.ReadOnly = new Wrapper(impl)
}
