package zio.aws.sesv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.{Timestamp, EmailAddress}
import scala.jdk.CollectionConverters.*
final case class SuppressedDestination(
    emailAddress: EmailAddress,
    reason: zio.aws.sesv2.model.SuppressionListReason,
    lastUpdateTime: Timestamp,
    attributes: Optional[zio.aws.sesv2.model.SuppressedDestinationAttributes] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.SuppressedDestination = {
    import SuppressedDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.SuppressedDestination
      .builder()
      .emailAddress(EmailAddress.unwrap(emailAddress): java.lang.String)
      .reason(reason.unwrap)
      .lastUpdateTime(Timestamp.unwrap(lastUpdateTime): Instant)
      .optionallyWith(attributes.map(value => value.buildAwsValue()))(
        _.attributes
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.SuppressedDestination.ReadOnly =
    zio.aws.sesv2.model.SuppressedDestination.wrap(buildAwsValue())
}
object SuppressedDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.SuppressedDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.SuppressedDestination =
      zio.aws.sesv2.model.SuppressedDestination(
        emailAddress,
        reason,
        lastUpdateTime,
        attributes.map(value => value.asEditable)
      )
    def emailAddress: EmailAddress
    def reason: zio.aws.sesv2.model.SuppressionListReason
    def lastUpdateTime: Timestamp
    def attributes
        : Optional[zio.aws.sesv2.model.SuppressedDestinationAttributes.ReadOnly]
    def getEmailAddress: ZIO[Any, Nothing, EmailAddress] =
      ZIO.succeed(emailAddress)
    def getReason
        : ZIO[Any, Nothing, zio.aws.sesv2.model.SuppressionListReason] =
      ZIO.succeed(reason)
    def getLastUpdateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdateTime)
    def getAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.sesv2.model.SuppressedDestinationAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.SuppressedDestination
  ) extends zio.aws.sesv2.model.SuppressedDestination.ReadOnly {
    override val emailAddress: EmailAddress =
      zio.aws.sesv2.model.primitives.EmailAddress(impl.emailAddress())
    override val reason: zio.aws.sesv2.model.SuppressionListReason =
      zio.aws.sesv2.model.SuppressionListReason.wrap(impl.reason())
    override val lastUpdateTime: Timestamp =
      zio.aws.sesv2.model.primitives.Timestamp(impl.lastUpdateTime())
    override val attributes: Optional[
      zio.aws.sesv2.model.SuppressedDestinationAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attributes())
      .map(value =>
        zio.aws.sesv2.model.SuppressedDestinationAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.SuppressedDestination
  ): zio.aws.sesv2.model.SuppressedDestination.ReadOnly = new Wrapper(impl)
}
