package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SuppressionOptions(
    suppressedReasons: Optional[
      Iterable[zio.aws.sesv2.model.SuppressionListReason]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.SuppressionOptions = {
    import SuppressionOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.SuppressionOptions
      .builder()
      .optionallyWith(
        suppressedReasons.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.suppressedReasonsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.SuppressionOptions.ReadOnly =
    zio.aws.sesv2.model.SuppressionOptions.wrap(buildAwsValue())
}
object SuppressionOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.SuppressionOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.SuppressionOptions = zio.aws.sesv2.model
      .SuppressionOptions(suppressedReasons.map(value => value))
    def suppressedReasons
        : Optional[List[zio.aws.sesv2.model.SuppressionListReason]]
    def getSuppressedReasons
        : ZIO[Any, AwsError, List[zio.aws.sesv2.model.SuppressionListReason]] =
      AwsError.unwrapOptionField("suppressedReasons", suppressedReasons)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.SuppressionOptions
  ) extends zio.aws.sesv2.model.SuppressionOptions.ReadOnly {
    override val suppressedReasons
        : Optional[List[zio.aws.sesv2.model.SuppressionListReason]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suppressedReasons())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.SuppressionListReason.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.SuppressionOptions
  ): zio.aws.sesv2.model.SuppressionOptions.ReadOnly = new Wrapper(impl)
}
