package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: AmazonResourceName,
    tags: Iterable[zio.aws.sesv2.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.TagResourceRequest
      .builder()
      .resourceArn(AmazonResourceName.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.TagResourceRequest.ReadOnly =
    zio.aws.sesv2.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.TagResourceRequest =
      zio.aws.sesv2.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: AmazonResourceName
    def tags: List[zio.aws.sesv2.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, List[zio.aws.sesv2.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.TagResourceRequest
  ) extends zio.aws.sesv2.model.TagResourceRequest.ReadOnly {
    override val resourceArn: AmazonResourceName =
      zio.aws.sesv2.model.primitives.AmazonResourceName(impl.resourceArn())
    override val tags: List[zio.aws.sesv2.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.sesv2.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.TagResourceRequest
  ): zio.aws.sesv2.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
