package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.TopicName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TopicPreference(
    topicName: TopicName,
    subscriptionStatus: zio.aws.sesv2.model.SubscriptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.TopicPreference = {
    import TopicPreference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.TopicPreference
      .builder()
      .topicName(TopicName.unwrap(topicName): java.lang.String)
      .subscriptionStatus(subscriptionStatus.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.TopicPreference.ReadOnly =
    zio.aws.sesv2.model.TopicPreference.wrap(buildAwsValue())
}
object TopicPreference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.TopicPreference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.TopicPreference =
      zio.aws.sesv2.model.TopicPreference(topicName, subscriptionStatus)
    def topicName: TopicName
    def subscriptionStatus: zio.aws.sesv2.model.SubscriptionStatus
    def getTopicName: ZIO[Any, Nothing, TopicName] = ZIO.succeed(topicName)
    def getSubscriptionStatus
        : ZIO[Any, Nothing, zio.aws.sesv2.model.SubscriptionStatus] =
      ZIO.succeed(subscriptionStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.TopicPreference
  ) extends zio.aws.sesv2.model.TopicPreference.ReadOnly {
    override val topicName: TopicName =
      zio.aws.sesv2.model.primitives.TopicName(impl.topicName())
    override val subscriptionStatus: zio.aws.sesv2.model.SubscriptionStatus =
      zio.aws.sesv2.model.SubscriptionStatus.wrap(impl.subscriptionStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.TopicPreference
  ): zio.aws.sesv2.model.TopicPreference.ReadOnly = new Wrapper(impl)
}
