package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{
  AttributesData,
  UnsubscribeAll,
  EmailAddress,
  ContactListName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateContactRequest(
    contactListName: ContactListName,
    emailAddress: EmailAddress,
    topicPreferences: Optional[Iterable[zio.aws.sesv2.model.TopicPreference]] =
      Optional.Absent,
    unsubscribeAll: Optional[UnsubscribeAll] = Optional.Absent,
    attributesData: Optional[AttributesData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.UpdateContactRequest = {
    import UpdateContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.UpdateContactRequest
      .builder()
      .contactListName(
        ContactListName.unwrap(contactListName): java.lang.String
      )
      .emailAddress(EmailAddress.unwrap(emailAddress): java.lang.String)
      .optionallyWith(
        topicPreferences.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.topicPreferences)
      .optionallyWith(
        unsubscribeAll.map(value =>
          UnsubscribeAll.unwrap(value): java.lang.Boolean
        )
      )(_.unsubscribeAll)
      .optionallyWith(
        attributesData.map(value =>
          AttributesData.unwrap(value): java.lang.String
        )
      )(_.attributesData)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.UpdateContactRequest.ReadOnly =
    zio.aws.sesv2.model.UpdateContactRequest.wrap(buildAwsValue())
}
object UpdateContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.UpdateContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.UpdateContactRequest =
      zio.aws.sesv2.model.UpdateContactRequest(
        contactListName,
        emailAddress,
        topicPreferences.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unsubscribeAll.map(value => value),
        attributesData.map(value => value)
      )
    def contactListName: ContactListName
    def emailAddress: EmailAddress
    def topicPreferences
        : Optional[List[zio.aws.sesv2.model.TopicPreference.ReadOnly]]
    def unsubscribeAll: Optional[UnsubscribeAll]
    def attributesData: Optional[AttributesData]
    def getContactListName: ZIO[Any, Nothing, ContactListName] =
      ZIO.succeed(contactListName)
    def getEmailAddress: ZIO[Any, Nothing, EmailAddress] =
      ZIO.succeed(emailAddress)
    def getTopicPreferences: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.TopicPreference.ReadOnly
    ]] = AwsError.unwrapOptionField("topicPreferences", topicPreferences)
    def getUnsubscribeAll: ZIO[Any, AwsError, UnsubscribeAll] =
      AwsError.unwrapOptionField("unsubscribeAll", unsubscribeAll)
    def getAttributesData: ZIO[Any, AwsError, AttributesData] =
      AwsError.unwrapOptionField("attributesData", attributesData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.UpdateContactRequest
  ) extends zio.aws.sesv2.model.UpdateContactRequest.ReadOnly {
    override val contactListName: ContactListName =
      zio.aws.sesv2.model.primitives.ContactListName(impl.contactListName())
    override val emailAddress: EmailAddress =
      zio.aws.sesv2.model.primitives.EmailAddress(impl.emailAddress())
    override val topicPreferences
        : Optional[List[zio.aws.sesv2.model.TopicPreference.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.topicPreferences())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.TopicPreference.wrap(item)
          }.toList
        )
    override val unsubscribeAll: Optional[UnsubscribeAll] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unsubscribeAll())
        .map(value => zio.aws.sesv2.model.primitives.UnsubscribeAll(value))
    override val attributesData: Optional[AttributesData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributesData())
        .map(value => zio.aws.sesv2.model.primitives.AttributesData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.UpdateContactRequest
  ): zio.aws.sesv2.model.UpdateContactRequest.ReadOnly = new Wrapper(impl)
}
