package zio.aws.sfn
import zio.aws.sfn.model.ListTagsForResourceResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.sfn.SfnAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.sfn.model.{
  SendTaskFailureRequest,
  DescribeStateMachineForExecutionRequest,
  CreateStateMachineAliasRequest,
  SendTaskHeartbeatRequest,
  UpdateStateMachineRequest,
  ListStateMachineAliasesRequest,
  GetActivityTaskRequest,
  PublishStateMachineVersionRequest,
  ListTagsForResourceRequest,
  DescribeStateMachineAliasRequest,
  StartSyncExecutionRequest,
  GetExecutionHistoryRequest,
  StartExecutionRequest,
  UpdateStateMachineAliasRequest,
  ListExecutionsRequest,
  ValidateStateMachineDefinitionRequest,
  CreateStateMachineRequest,
  CreateActivityRequest,
  UpdateMapRunRequest,
  DescribeActivityRequest,
  DeleteStateMachineAliasRequest,
  ListActivitiesRequest,
  StopExecutionRequest,
  DescribeStateMachineRequest,
  DeleteStateMachineRequest,
  UntagResourceRequest,
  ListStateMachinesRequest,
  DeleteActivityRequest,
  TestStateRequest,
  DescribeMapRunRequest,
  SendTaskSuccessRequest,
  DeleteStateMachineVersionRequest,
  ListStateMachineVersionsRequest,
  RedriveExecutionRequest,
  ListMapRunsRequest,
  DescribeExecutionRequest,
  TagResourceRequest
}
import zio.stream.ZStream
object SfnMock extends Mock[Sfn] {
  object UpdateStateMachineAlias
      extends Effect[
        UpdateStateMachineAliasRequest,
        AwsError,
        zio.aws.sfn.model.UpdateStateMachineAliasResponse.ReadOnly
      ]
  object StartExecution
      extends Effect[
        StartExecutionRequest,
        AwsError,
        zio.aws.sfn.model.StartExecutionResponse.ReadOnly
      ]
  object UpdateMapRun
      extends Effect[
        UpdateMapRunRequest,
        AwsError,
        zio.aws.sfn.model.UpdateMapRunResponse.ReadOnly
      ]
  object GetExecutionHistory
      extends Stream[
        GetExecutionHistoryRequest,
        AwsError,
        zio.aws.sfn.model.HistoryEvent.ReadOnly
      ]
  object GetExecutionHistoryPaginated
      extends Effect[
        GetExecutionHistoryRequest,
        AwsError,
        zio.aws.sfn.model.GetExecutionHistoryResponse.ReadOnly
      ]
  object DeleteStateMachine
      extends Effect[
        DeleteStateMachineRequest,
        AwsError,
        zio.aws.sfn.model.DeleteStateMachineResponse.ReadOnly
      ]
  object CreateStateMachine
      extends Effect[
        CreateStateMachineRequest,
        AwsError,
        zio.aws.sfn.model.CreateStateMachineResponse.ReadOnly
      ]
  object ListStateMachineAliases
      extends Effect[
        ListStateMachineAliasesRequest,
        AwsError,
        zio.aws.sfn.model.ListStateMachineAliasesResponse.ReadOnly
      ]
  object DescribeStateMachineForExecution
      extends Effect[
        DescribeStateMachineForExecutionRequest,
        AwsError,
        zio.aws.sfn.model.DescribeStateMachineForExecutionResponse.ReadOnly
      ]
  object StopExecution
      extends Effect[
        StopExecutionRequest,
        AwsError,
        zio.aws.sfn.model.StopExecutionResponse.ReadOnly
      ]
  object GetActivityTask
      extends Effect[
        GetActivityTaskRequest,
        AwsError,
        zio.aws.sfn.model.GetActivityTaskResponse.ReadOnly
      ]
  object DescribeExecution
      extends Effect[
        DescribeExecutionRequest,
        AwsError,
        zio.aws.sfn.model.DescribeExecutionResponse.ReadOnly
      ]
  object StartSyncExecution
      extends Effect[
        StartSyncExecutionRequest,
        AwsError,
        zio.aws.sfn.model.StartSyncExecutionResponse.ReadOnly
      ]
  object SendTaskSuccess
      extends Effect[
        SendTaskSuccessRequest,
        AwsError,
        zio.aws.sfn.model.SendTaskSuccessResponse.ReadOnly
      ]
  object SendTaskHeartbeat
      extends Effect[
        SendTaskHeartbeatRequest,
        AwsError,
        zio.aws.sfn.model.SendTaskHeartbeatResponse.ReadOnly
      ]
  object DescribeStateMachine
      extends Effect[
        DescribeStateMachineRequest,
        AwsError,
        zio.aws.sfn.model.DescribeStateMachineResponse.ReadOnly
      ]
  object TestState
      extends Effect[
        TestStateRequest,
        AwsError,
        zio.aws.sfn.model.TestStateResponse.ReadOnly
      ]
  object DeleteActivity
      extends Effect[
        DeleteActivityRequest,
        AwsError,
        zio.aws.sfn.model.DeleteActivityResponse.ReadOnly
      ]
  object ListMapRuns
      extends Stream[
        ListMapRunsRequest,
        AwsError,
        zio.aws.sfn.model.MapRunListItem.ReadOnly
      ]
  object ListMapRunsPaginated
      extends Effect[
        ListMapRunsRequest,
        AwsError,
        zio.aws.sfn.model.ListMapRunsResponse.ReadOnly
      ]
  object DeleteStateMachineAlias
      extends Effect[
        DeleteStateMachineAliasRequest,
        AwsError,
        zio.aws.sfn.model.DeleteStateMachineAliasResponse.ReadOnly
      ]
  object UpdateStateMachine
      extends Effect[
        UpdateStateMachineRequest,
        AwsError,
        zio.aws.sfn.model.UpdateStateMachineResponse.ReadOnly
      ]
  object ListStateMachineVersions
      extends Effect[
        ListStateMachineVersionsRequest,
        AwsError,
        zio.aws.sfn.model.ListStateMachineVersionsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.sfn.model.UntagResourceResponse.ReadOnly
      ]
  object ListActivities
      extends Stream[
        ListActivitiesRequest,
        AwsError,
        zio.aws.sfn.model.ActivityListItem.ReadOnly
      ]
  object ListActivitiesPaginated
      extends Effect[
        ListActivitiesRequest,
        AwsError,
        zio.aws.sfn.model.ListActivitiesResponse.ReadOnly
      ]
  object ListStateMachines
      extends Stream[
        ListStateMachinesRequest,
        AwsError,
        zio.aws.sfn.model.StateMachineListItem.ReadOnly
      ]
  object ListStateMachinesPaginated
      extends Effect[
        ListStateMachinesRequest,
        AwsError,
        zio.aws.sfn.model.ListStateMachinesResponse.ReadOnly
      ]
  object PublishStateMachineVersion
      extends Effect[
        PublishStateMachineVersionRequest,
        AwsError,
        zio.aws.sfn.model.PublishStateMachineVersionResponse.ReadOnly
      ]
  object DescribeMapRun
      extends Effect[
        DescribeMapRunRequest,
        AwsError,
        zio.aws.sfn.model.DescribeMapRunResponse.ReadOnly
      ]
  object ListExecutions
      extends Stream[
        ListExecutionsRequest,
        AwsError,
        zio.aws.sfn.model.ExecutionListItem.ReadOnly
      ]
  object ListExecutionsPaginated
      extends Effect[
        ListExecutionsRequest,
        AwsError,
        zio.aws.sfn.model.ListExecutionsResponse.ReadOnly
      ]
  object CreateActivity
      extends Effect[
        CreateActivityRequest,
        AwsError,
        zio.aws.sfn.model.CreateActivityResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[ListTagsForResourceRequest, AwsError, ReadOnly]
  object SendTaskFailure
      extends Effect[
        SendTaskFailureRequest,
        AwsError,
        zio.aws.sfn.model.SendTaskFailureResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.sfn.model.TagResourceResponse.ReadOnly
      ]
  object ValidateStateMachineDefinition
      extends Effect[
        ValidateStateMachineDefinitionRequest,
        AwsError,
        zio.aws.sfn.model.ValidateStateMachineDefinitionResponse.ReadOnly
      ]
  object RedriveExecution
      extends Effect[
        RedriveExecutionRequest,
        AwsError,
        zio.aws.sfn.model.RedriveExecutionResponse.ReadOnly
      ]
  object DeleteStateMachineVersion
      extends Effect[
        DeleteStateMachineVersionRequest,
        AwsError,
        zio.aws.sfn.model.DeleteStateMachineVersionResponse.ReadOnly
      ]
  object DescribeStateMachineAlias
      extends Effect[
        DescribeStateMachineAliasRequest,
        AwsError,
        zio.aws.sfn.model.DescribeStateMachineAliasResponse.ReadOnly
      ]
  object DescribeActivity
      extends Effect[
        DescribeActivityRequest,
        AwsError,
        zio.aws.sfn.model.DescribeActivityResponse.ReadOnly
      ]
  object CreateStateMachineAlias
      extends Effect[
        CreateStateMachineAliasRequest,
        AwsError,
        zio.aws.sfn.model.CreateStateMachineAliasResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Sfn] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Sfn] { rts =>
        zio.ZIO.succeed {
          new Sfn {
            val api: SfnAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Sfn = this
            def updateStateMachineAlias(
                request: UpdateStateMachineAliasRequest
            ): IO[
              AwsError,
              zio.aws.sfn.model.UpdateStateMachineAliasResponse.ReadOnly
            ] = proxy(UpdateStateMachineAlias, request)
            def startExecution(
                request: StartExecutionRequest
            ): IO[AwsError, zio.aws.sfn.model.StartExecutionResponse.ReadOnly] =
              proxy(StartExecution, request)
            def updateMapRun(
                request: UpdateMapRunRequest
            ): IO[AwsError, zio.aws.sfn.model.UpdateMapRunResponse.ReadOnly] =
              proxy(UpdateMapRun, request)
            def getExecutionHistory(
                request: GetExecutionHistoryRequest
            ): ZStream[Any, AwsError, zio.aws.sfn.model.HistoryEvent.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(GetExecutionHistory, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def getExecutionHistoryPaginated(
                request: GetExecutionHistoryRequest
            ): IO[
              AwsError,
              zio.aws.sfn.model.GetExecutionHistoryResponse.ReadOnly
            ] = proxy(GetExecutionHistoryPaginated, request)
            def deleteStateMachine(request: DeleteStateMachineRequest): IO[
              AwsError,
              zio.aws.sfn.model.DeleteStateMachineResponse.ReadOnly
            ] = proxy(DeleteStateMachine, request)
            def createStateMachine(request: CreateStateMachineRequest): IO[
              AwsError,
              zio.aws.sfn.model.CreateStateMachineResponse.ReadOnly
            ] = proxy(CreateStateMachine, request)
            def listStateMachineAliases(
                request: ListStateMachineAliasesRequest
            ): IO[
              AwsError,
              zio.aws.sfn.model.ListStateMachineAliasesResponse.ReadOnly
            ] = proxy(ListStateMachineAliases, request)
            def describeStateMachineForExecution(
                request: DescribeStateMachineForExecutionRequest
            ): IO[
              AwsError,
              zio.aws.sfn.model.DescribeStateMachineForExecutionResponse.ReadOnly
            ] = proxy(DescribeStateMachineForExecution, request)
            def stopExecution(
                request: StopExecutionRequest
            ): IO[AwsError, zio.aws.sfn.model.StopExecutionResponse.ReadOnly] =
              proxy(StopExecution, request)
            def getActivityTask(request: GetActivityTaskRequest): IO[
              AwsError,
              zio.aws.sfn.model.GetActivityTaskResponse.ReadOnly
            ] = proxy(GetActivityTask, request)
            def describeExecution(request: DescribeExecutionRequest): IO[
              AwsError,
              zio.aws.sfn.model.DescribeExecutionResponse.ReadOnly
            ] = proxy(DescribeExecution, request)
            def startSyncExecution(request: StartSyncExecutionRequest): IO[
              AwsError,
              zio.aws.sfn.model.StartSyncExecutionResponse.ReadOnly
            ] = proxy(StartSyncExecution, request)
            def sendTaskSuccess(request: SendTaskSuccessRequest): IO[
              AwsError,
              zio.aws.sfn.model.SendTaskSuccessResponse.ReadOnly
            ] = proxy(SendTaskSuccess, request)
            def sendTaskHeartbeat(request: SendTaskHeartbeatRequest): IO[
              AwsError,
              zio.aws.sfn.model.SendTaskHeartbeatResponse.ReadOnly
            ] = proxy(SendTaskHeartbeat, request)
            def describeStateMachine(request: DescribeStateMachineRequest): IO[
              AwsError,
              zio.aws.sfn.model.DescribeStateMachineResponse.ReadOnly
            ] = proxy(DescribeStateMachine, request)
            def testState(
                request: TestStateRequest
            ): IO[AwsError, zio.aws.sfn.model.TestStateResponse.ReadOnly] =
              proxy(TestState, request)
            def deleteActivity(
                request: DeleteActivityRequest
            ): IO[AwsError, zio.aws.sfn.model.DeleteActivityResponse.ReadOnly] =
              proxy(DeleteActivity, request)
            def listMapRuns(request: ListMapRunsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sfn.model.MapRunListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListMapRuns, request)
                }
                .getOrThrowFiberFailure()
            }
            def listMapRunsPaginated(
                request: ListMapRunsRequest
            ): IO[AwsError, zio.aws.sfn.model.ListMapRunsResponse.ReadOnly] =
              proxy(ListMapRunsPaginated, request)
            def deleteStateMachineAlias(
                request: DeleteStateMachineAliasRequest
            ): IO[
              AwsError,
              zio.aws.sfn.model.DeleteStateMachineAliasResponse.ReadOnly
            ] = proxy(DeleteStateMachineAlias, request)
            def updateStateMachine(request: UpdateStateMachineRequest): IO[
              AwsError,
              zio.aws.sfn.model.UpdateStateMachineResponse.ReadOnly
            ] = proxy(UpdateStateMachine, request)
            def listStateMachineVersions(
                request: ListStateMachineVersionsRequest
            ): IO[
              AwsError,
              zio.aws.sfn.model.ListStateMachineVersionsResponse.ReadOnly
            ] = proxy(ListStateMachineVersions, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, zio.aws.sfn.model.UntagResourceResponse.ReadOnly] =
              proxy(UntagResource, request)
            def listActivities(request: ListActivitiesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sfn.model.ActivityListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListActivities, request)
                }
                .getOrThrowFiberFailure()
            }
            def listActivitiesPaginated(
                request: ListActivitiesRequest
            ): IO[AwsError, zio.aws.sfn.model.ListActivitiesResponse.ReadOnly] =
              proxy(ListActivitiesPaginated, request)
            def listStateMachines(request: ListStateMachinesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sfn.model.StateMachineListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListStateMachines, request)
                }
                .getOrThrowFiberFailure()
            }
            def listStateMachinesPaginated(
                request: ListStateMachinesRequest
            ): IO[
              AwsError,
              zio.aws.sfn.model.ListStateMachinesResponse.ReadOnly
            ] = proxy(ListStateMachinesPaginated, request)
            def publishStateMachineVersion(
                request: PublishStateMachineVersionRequest
            ): IO[
              AwsError,
              zio.aws.sfn.model.PublishStateMachineVersionResponse.ReadOnly
            ] = proxy(PublishStateMachineVersion, request)
            def describeMapRun(
                request: DescribeMapRunRequest
            ): IO[AwsError, zio.aws.sfn.model.DescribeMapRunResponse.ReadOnly] =
              proxy(DescribeMapRun, request)
            def listExecutions(request: ListExecutionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sfn.model.ExecutionListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListExecutions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listExecutionsPaginated(
                request: ListExecutionsRequest
            ): IO[AwsError, zio.aws.sfn.model.ListExecutionsResponse.ReadOnly] =
              proxy(ListExecutionsPaginated, request)
            def createActivity(
                request: CreateActivityRequest
            ): IO[AwsError, zio.aws.sfn.model.CreateActivityResponse.ReadOnly] =
              proxy(CreateActivity, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): IO[AwsError, ReadOnly] = proxy(ListTagsForResource, request)
            def sendTaskFailure(request: SendTaskFailureRequest): IO[
              AwsError,
              zio.aws.sfn.model.SendTaskFailureResponse.ReadOnly
            ] = proxy(SendTaskFailure, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, zio.aws.sfn.model.TagResourceResponse.ReadOnly] =
              proxy(TagResource, request)
            def validateStateMachineDefinition(
                request: ValidateStateMachineDefinitionRequest
            ): IO[
              AwsError,
              zio.aws.sfn.model.ValidateStateMachineDefinitionResponse.ReadOnly
            ] = proxy(ValidateStateMachineDefinition, request)
            def redriveExecution(request: RedriveExecutionRequest): IO[
              AwsError,
              zio.aws.sfn.model.RedriveExecutionResponse.ReadOnly
            ] = proxy(RedriveExecution, request)
            def deleteStateMachineVersion(
                request: DeleteStateMachineVersionRequest
            ): IO[
              AwsError,
              zio.aws.sfn.model.DeleteStateMachineVersionResponse.ReadOnly
            ] = proxy(DeleteStateMachineVersion, request)
            def describeStateMachineAlias(
                request: DescribeStateMachineAliasRequest
            ): IO[
              AwsError,
              zio.aws.sfn.model.DescribeStateMachineAliasResponse.ReadOnly
            ] = proxy(DescribeStateMachineAlias, request)
            def describeActivity(request: DescribeActivityRequest): IO[
              AwsError,
              zio.aws.sfn.model.DescribeActivityResponse.ReadOnly
            ] = proxy(DescribeActivity, request)
            def createStateMachineAlias(
                request: CreateStateMachineAliasRequest
            ): IO[
              AwsError,
              zio.aws.sfn.model.CreateStateMachineAliasResponse.ReadOnly
            ] = proxy(CreateStateMachineAlias, request)
          }
        }
      }
    }
  }
}
