package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{Timestamp, Name, Arn}
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ActivityListItem(
    activityArn: Arn,
    name: Name,
    creationDate: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ActivityListItem = {
    import ActivityListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ActivityListItem
      .builder()
      .activityArn(Arn.unwrap(activityArn): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .creationDate(Timestamp.unwrap(creationDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.ActivityListItem.ReadOnly =
    zio.aws.sfn.model.ActivityListItem.wrap(buildAwsValue())
}
object ActivityListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ActivityListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ActivityListItem =
      zio.aws.sfn.model.ActivityListItem(activityArn, name, creationDate)
    def activityArn: Arn
    def name: Name
    def creationDate: Timestamp
    def getActivityArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(activityArn)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ActivityListItem
  ) extends zio.aws.sfn.model.ActivityListItem.ReadOnly {
    override val activityArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.activityArn())
    override val name: Name = zio.aws.sfn.model.primitives.Name(impl.name())
    override val creationDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.creationDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ActivityListItem
  ): zio.aws.sfn.model.ActivityListItem.ReadOnly = new Wrapper(impl)
}
