package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.Identity
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ActivityStartedEventDetails(
    workerName: Optional[Identity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ActivityStartedEventDetails = {
    import ActivityStartedEventDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ActivityStartedEventDetails
      .builder()
      .optionallyWith(
        workerName.map(value => Identity.unwrap(value): java.lang.String)
      )(_.workerName)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.ActivityStartedEventDetails.ReadOnly =
    zio.aws.sfn.model.ActivityStartedEventDetails.wrap(buildAwsValue())
}
object ActivityStartedEventDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ActivityStartedEventDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ActivityStartedEventDetails =
      zio.aws.sfn.model
        .ActivityStartedEventDetails(workerName.map(value => value))
    def workerName: Optional[Identity]
    def getWorkerName: ZIO[Any, AwsError, Identity] =
      AwsError.unwrapOptionField("workerName", workerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ActivityStartedEventDetails
  ) extends zio.aws.sfn.model.ActivityStartedEventDetails.ReadOnly {
    override val workerName: Optional[Identity] = zio.aws.core.internal
      .optionalFromNullable(impl.workerName())
      .map(value => zio.aws.sfn.model.primitives.Identity(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ActivityStartedEventDetails
  ): zio.aws.sfn.model.ActivityStartedEventDetails.ReadOnly = new Wrapper(impl)
}
