package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.IncludedDetails
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CloudWatchEventsExecutionDataDetails(
    included: Optional[IncludedDetails] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.CloudWatchEventsExecutionDataDetails = {
    import CloudWatchEventsExecutionDataDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.CloudWatchEventsExecutionDataDetails
      .builder()
      .optionallyWith(
        included.map(value => IncludedDetails.unwrap(value): java.lang.Boolean)
      )(_.included)
      .build()
  }
  def asReadOnly
      : zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.ReadOnly =
    zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.wrap(buildAwsValue())
}
object CloudWatchEventsExecutionDataDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.CloudWatchEventsExecutionDataDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails =
      zio.aws.sfn.model
        .CloudWatchEventsExecutionDataDetails(included.map(value => value))
    def included: Optional[IncludedDetails]
    def getIncluded: ZIO[Any, AwsError, IncludedDetails] =
      AwsError.unwrapOptionField("included", included)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.CloudWatchEventsExecutionDataDetails
  ) extends zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.ReadOnly {
    override val included: Optional[IncludedDetails] = zio.aws.core.internal
      .optionalFromNullable(impl.included())
      .map(value => zio.aws.sfn.model.primitives.IncludedDetails(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.CloudWatchEventsExecutionDataDetails
  ): zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.ReadOnly =
    new Wrapper(impl)
}
