package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CloudWatchLogsLogGroup(
    logGroupArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.CloudWatchLogsLogGroup = {
    import CloudWatchLogsLogGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.CloudWatchLogsLogGroup
      .builder()
      .optionallyWith(
        logGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.logGroupArn)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.CloudWatchLogsLogGroup.ReadOnly =
    zio.aws.sfn.model.CloudWatchLogsLogGroup.wrap(buildAwsValue())
}
object CloudWatchLogsLogGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.CloudWatchLogsLogGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.CloudWatchLogsLogGroup =
      zio.aws.sfn.model.CloudWatchLogsLogGroup(logGroupArn.map(value => value))
    def logGroupArn: Optional[Arn]
    def getLogGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("logGroupArn", logGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.CloudWatchLogsLogGroup
  ) extends zio.aws.sfn.model.CloudWatchLogsLogGroup.ReadOnly {
    override val logGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.logGroupArn())
      .map(value => zio.aws.sfn.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.CloudWatchLogsLogGroup
  ): zio.aws.sfn.model.CloudWatchLogsLogGroup.ReadOnly = new Wrapper(impl)
}
