package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.Name
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateActivityRequest(
    name: Name,
    tags: Optional[Iterable[zio.aws.sfn.model.Tag]] = Optional.Absent,
    encryptionConfiguration: Optional[
      zio.aws.sfn.model.EncryptionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.CreateActivityRequest = {
    import CreateActivityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.CreateActivityRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.CreateActivityRequest.ReadOnly =
    zio.aws.sfn.model.CreateActivityRequest.wrap(buildAwsValue())
}
object CreateActivityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.CreateActivityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.CreateActivityRequest =
      zio.aws.sfn.model.CreateActivityRequest(
        name,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        encryptionConfiguration.map(value => value.asEditable)
      )
    def name: Name
    def tags: Optional[List[zio.aws.sfn.model.Tag.ReadOnly]]
    def encryptionConfiguration
        : Optional[zio.aws.sfn.model.EncryptionConfiguration.ReadOnly]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, List[zio.aws.sfn.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.CreateActivityRequest
  ) extends zio.aws.sfn.model.CreateActivityRequest.ReadOnly {
    override val name: Name = zio.aws.sfn.model.primitives.Name(impl.name())
    override val tags: Optional[List[zio.aws.sfn.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sfn.model.Tag.wrap(item)
          }.toList
        )
    override val encryptionConfiguration
        : Optional[zio.aws.sfn.model.EncryptionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionConfiguration())
        .map(value => zio.aws.sfn.model.EncryptionConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.CreateActivityRequest
  ): zio.aws.sfn.model.CreateActivityRequest.ReadOnly = new Wrapper(impl)
}
