package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{Timestamp, Arn}
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateActivityResponse(
    activityArn: Arn,
    creationDate: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.CreateActivityResponse = {
    import CreateActivityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.CreateActivityResponse
      .builder()
      .activityArn(Arn.unwrap(activityArn): java.lang.String)
      .creationDate(Timestamp.unwrap(creationDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.CreateActivityResponse.ReadOnly =
    zio.aws.sfn.model.CreateActivityResponse.wrap(buildAwsValue())
}
object CreateActivityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.CreateActivityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.CreateActivityResponse =
      zio.aws.sfn.model.CreateActivityResponse(activityArn, creationDate)
    def activityArn: Arn
    def creationDate: Timestamp
    def getActivityArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(activityArn)
    def getCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.CreateActivityResponse
  ) extends zio.aws.sfn.model.CreateActivityResponse.ReadOnly {
    override val activityArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.activityArn())
    override val creationDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.creationDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.CreateActivityResponse
  ): zio.aws.sfn.model.CreateActivityResponse.ReadOnly = new Wrapper(impl)
}
