package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{CharacterRestrictedName, AliasDescription}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateStateMachineAliasRequest(
    description: Optional[AliasDescription] = Optional.Absent,
    name: CharacterRestrictedName,
    routingConfiguration: Iterable[
      zio.aws.sfn.model.RoutingConfigurationListItem
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.CreateStateMachineAliasRequest = {
    import CreateStateMachineAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.CreateStateMachineAliasRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          AliasDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .name(CharacterRestrictedName.unwrap(name): java.lang.String)
      .routingConfiguration(routingConfiguration.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.CreateStateMachineAliasRequest.ReadOnly =
    zio.aws.sfn.model.CreateStateMachineAliasRequest.wrap(buildAwsValue())
}
object CreateStateMachineAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.CreateStateMachineAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.CreateStateMachineAliasRequest =
      zio.aws.sfn.model.CreateStateMachineAliasRequest(
        description.map(value => value),
        name,
        routingConfiguration.map { item =>
          item.asEditable
        }
      )
    def description: Optional[AliasDescription]
    def name: CharacterRestrictedName
    def routingConfiguration
        : List[zio.aws.sfn.model.RoutingConfigurationListItem.ReadOnly]
    def getDescription: ZIO[Any, AwsError, AliasDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, CharacterRestrictedName] = ZIO.succeed(name)
    def getRoutingConfiguration: ZIO[Any, Nothing, List[
      zio.aws.sfn.model.RoutingConfigurationListItem.ReadOnly
    ]] = ZIO.succeed(routingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.CreateStateMachineAliasRequest
  ) extends zio.aws.sfn.model.CreateStateMachineAliasRequest.ReadOnly {
    override val description: Optional[AliasDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.sfn.model.primitives.AliasDescription(value))
    override val name: CharacterRestrictedName =
      zio.aws.sfn.model.primitives.CharacterRestrictedName(impl.name())
    override val routingConfiguration
        : List[zio.aws.sfn.model.RoutingConfigurationListItem.ReadOnly] = impl
      .routingConfiguration()
      .asScala
      .map { item =>
        zio.aws.sfn.model.RoutingConfigurationListItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.CreateStateMachineAliasRequest
  ): zio.aws.sfn.model.CreateStateMachineAliasRequest.ReadOnly = new Wrapper(
    impl
  )
}
