package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{Timestamp, Arn}
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateStateMachineAliasResponse(
    stateMachineAliasArn: Arn,
    creationDate: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.CreateStateMachineAliasResponse = {
    import CreateStateMachineAliasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.CreateStateMachineAliasResponse
      .builder()
      .stateMachineAliasArn(Arn.unwrap(stateMachineAliasArn): java.lang.String)
      .creationDate(Timestamp.unwrap(creationDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.CreateStateMachineAliasResponse.ReadOnly =
    zio.aws.sfn.model.CreateStateMachineAliasResponse.wrap(buildAwsValue())
}
object CreateStateMachineAliasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.CreateStateMachineAliasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.CreateStateMachineAliasResponse =
      zio.aws.sfn.model
        .CreateStateMachineAliasResponse(stateMachineAliasArn, creationDate)
    def stateMachineAliasArn: Arn
    def creationDate: Timestamp
    def getStateMachineAliasArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineAliasArn)
    def getCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.CreateStateMachineAliasResponse
  ) extends zio.aws.sfn.model.CreateStateMachineAliasResponse.ReadOnly {
    override val stateMachineAliasArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineAliasArn())
    override val creationDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.creationDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.CreateStateMachineAliasResponse
  ): zio.aws.sfn.model.CreateStateMachineAliasResponse.ReadOnly = new Wrapper(
    impl
  )
}
