package zio.aws.sfn.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{Timestamp, Arn}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateStateMachineResponse(
    stateMachineArn: Arn,
    creationDate: Timestamp,
    stateMachineVersionArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.CreateStateMachineResponse = {
    import CreateStateMachineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.CreateStateMachineResponse
      .builder()
      .stateMachineArn(Arn.unwrap(stateMachineArn): java.lang.String)
      .creationDate(Timestamp.unwrap(creationDate): Instant)
      .optionallyWith(
        stateMachineVersionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.stateMachineVersionArn)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.CreateStateMachineResponse.ReadOnly =
    zio.aws.sfn.model.CreateStateMachineResponse.wrap(buildAwsValue())
}
object CreateStateMachineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.CreateStateMachineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.CreateStateMachineResponse =
      zio.aws.sfn.model.CreateStateMachineResponse(
        stateMachineArn,
        creationDate,
        stateMachineVersionArn.map(value => value)
      )
    def stateMachineArn: Arn
    def creationDate: Timestamp
    def stateMachineVersionArn: Optional[Arn]
    def getStateMachineArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineArn)
    def getCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDate)
    def getStateMachineVersionArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("stateMachineVersionArn", stateMachineVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.CreateStateMachineResponse
  ) extends zio.aws.sfn.model.CreateStateMachineResponse.ReadOnly {
    override val stateMachineArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineArn())
    override val creationDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.creationDate())
    override val stateMachineVersionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.stateMachineVersionArn())
      .map(value => zio.aws.sfn.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.CreateStateMachineResponse
  ): zio.aws.sfn.model.CreateStateMachineResponse.ReadOnly = new Wrapper(impl)
}
