package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteStateMachineAliasRequest(stateMachineAliasArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.DeleteStateMachineAliasRequest = {
    import DeleteStateMachineAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.DeleteStateMachineAliasRequest
      .builder()
      .stateMachineAliasArn(Arn.unwrap(stateMachineAliasArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.DeleteStateMachineAliasRequest.ReadOnly =
    zio.aws.sfn.model.DeleteStateMachineAliasRequest.wrap(buildAwsValue())
}
object DeleteStateMachineAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.DeleteStateMachineAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.DeleteStateMachineAliasRequest =
      zio.aws.sfn.model.DeleteStateMachineAliasRequest(stateMachineAliasArn)
    def stateMachineAliasArn: Arn
    def getStateMachineAliasArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineAliasArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.DeleteStateMachineAliasRequest
  ) extends zio.aws.sfn.model.DeleteStateMachineAliasRequest.ReadOnly {
    override val stateMachineAliasArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineAliasArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.DeleteStateMachineAliasRequest
  ): zio.aws.sfn.model.DeleteStateMachineAliasRequest.ReadOnly = new Wrapper(
    impl
  )
}
