package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.LongArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteStateMachineVersionRequest(
    stateMachineVersionArn: LongArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.DeleteStateMachineVersionRequest = {
    import DeleteStateMachineVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.DeleteStateMachineVersionRequest
      .builder()
      .stateMachineVersionArn(
        LongArn.unwrap(stateMachineVersionArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.DeleteStateMachineVersionRequest.ReadOnly =
    zio.aws.sfn.model.DeleteStateMachineVersionRequest.wrap(buildAwsValue())
}
object DeleteStateMachineVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.DeleteStateMachineVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.DeleteStateMachineVersionRequest =
      zio.aws.sfn.model.DeleteStateMachineVersionRequest(stateMachineVersionArn)
    def stateMachineVersionArn: LongArn
    def getStateMachineVersionArn: ZIO[Any, Nothing, LongArn] =
      ZIO.succeed(stateMachineVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.DeleteStateMachineVersionRequest
  ) extends zio.aws.sfn.model.DeleteStateMachineVersionRequest.ReadOnly {
    override val stateMachineVersionArn: LongArn =
      zio.aws.sfn.model.primitives.LongArn(impl.stateMachineVersionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.DeleteStateMachineVersionRequest
  ): zio.aws.sfn.model.DeleteStateMachineVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
