package zio.aws.sfn.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{Timestamp, Name, Arn}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeActivityResponse(
    activityArn: Arn,
    name: Name,
    creationDate: Timestamp,
    encryptionConfiguration: Optional[
      zio.aws.sfn.model.EncryptionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.DescribeActivityResponse = {
    import DescribeActivityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.DescribeActivityResponse
      .builder()
      .activityArn(Arn.unwrap(activityArn): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .creationDate(Timestamp.unwrap(creationDate): Instant)
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.DescribeActivityResponse.ReadOnly =
    zio.aws.sfn.model.DescribeActivityResponse.wrap(buildAwsValue())
}
object DescribeActivityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.DescribeActivityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.DescribeActivityResponse =
      zio.aws.sfn.model.DescribeActivityResponse(
        activityArn,
        name,
        creationDate,
        encryptionConfiguration.map(value => value.asEditable)
      )
    def activityArn: Arn
    def name: Name
    def creationDate: Timestamp
    def encryptionConfiguration
        : Optional[zio.aws.sfn.model.EncryptionConfiguration.ReadOnly]
    def getActivityArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(activityArn)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDate)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.DescribeActivityResponse
  ) extends zio.aws.sfn.model.DescribeActivityResponse.ReadOnly {
    override val activityArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.activityArn())
    override val name: Name = zio.aws.sfn.model.primitives.Name(impl.name())
    override val creationDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.creationDate())
    override val encryptionConfiguration
        : Optional[zio.aws.sfn.model.EncryptionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionConfiguration())
        .map(value => zio.aws.sfn.model.EncryptionConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.DescribeActivityResponse
  ): zio.aws.sfn.model.DescribeActivityResponse.ReadOnly = new Wrapper(impl)
}
