package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeExecutionRequest(
    executionArn: Arn,
    includedData: Optional[zio.aws.sfn.model.IncludedData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.DescribeExecutionRequest = {
    import DescribeExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.DescribeExecutionRequest
      .builder()
      .executionArn(Arn.unwrap(executionArn): java.lang.String)
      .optionallyWith(includedData.map(value => value.unwrap))(_.includedData)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.DescribeExecutionRequest.ReadOnly =
    zio.aws.sfn.model.DescribeExecutionRequest.wrap(buildAwsValue())
}
object DescribeExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.DescribeExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.DescribeExecutionRequest =
      zio.aws.sfn.model.DescribeExecutionRequest(
        executionArn,
        includedData.map(value => value)
      )
    def executionArn: Arn
    def includedData: Optional[zio.aws.sfn.model.IncludedData]
    def getExecutionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(executionArn)
    def getIncludedData: ZIO[Any, AwsError, zio.aws.sfn.model.IncludedData] =
      AwsError.unwrapOptionField("includedData", includedData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.DescribeExecutionRequest
  ) extends zio.aws.sfn.model.DescribeExecutionRequest.ReadOnly {
    override val executionArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.executionArn())
    override val includedData: Optional[zio.aws.sfn.model.IncludedData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includedData())
        .map(value => zio.aws.sfn.model.IncludedData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.DescribeExecutionRequest
  ): zio.aws.sfn.model.DescribeExecutionRequest.ReadOnly = new Wrapper(impl)
}
