package zio.aws.sfn.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{
  LongArn,
  RedriveCount,
  Timestamp,
  SensitiveError,
  Arn,
  SensitiveCause,
  SensitiveData,
  TraceHeader,
  Name
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeExecutionResponse(
    executionArn: Arn,
    stateMachineArn: Arn,
    name: Optional[Name] = Optional.Absent,
    status: zio.aws.sfn.model.ExecutionStatus,
    startDate: Timestamp,
    stopDate: Optional[Timestamp] = Optional.Absent,
    input: Optional[SensitiveData] = Optional.Absent,
    inputDetails: Optional[
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails
    ] = Optional.Absent,
    output: Optional[SensitiveData] = Optional.Absent,
    outputDetails: Optional[
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails
    ] = Optional.Absent,
    traceHeader: Optional[TraceHeader] = Optional.Absent,
    mapRunArn: Optional[LongArn] = Optional.Absent,
    error: Optional[SensitiveError] = Optional.Absent,
    cause: Optional[SensitiveCause] = Optional.Absent,
    stateMachineVersionArn: Optional[Arn] = Optional.Absent,
    stateMachineAliasArn: Optional[Arn] = Optional.Absent,
    redriveCount: Optional[RedriveCount] = Optional.Absent,
    redriveDate: Optional[Timestamp] = Optional.Absent,
    redriveStatus: Optional[zio.aws.sfn.model.ExecutionRedriveStatus] =
      Optional.Absent,
    redriveStatusReason: Optional[SensitiveData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.DescribeExecutionResponse = {
    import DescribeExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.DescribeExecutionResponse
      .builder()
      .executionArn(Arn.unwrap(executionArn): java.lang.String)
      .stateMachineArn(Arn.unwrap(stateMachineArn): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .status(status.unwrap)
      .startDate(Timestamp.unwrap(startDate): Instant)
      .optionallyWith(stopDate.map(value => Timestamp.unwrap(value): Instant))(
        _.stopDate
      )
      .optionallyWith(
        input.map(value => SensitiveData.unwrap(value): java.lang.String)
      )(_.input)
      .optionallyWith(inputDetails.map(value => value.buildAwsValue()))(
        _.inputDetails
      )
      .optionallyWith(
        output.map(value => SensitiveData.unwrap(value): java.lang.String)
      )(_.output)
      .optionallyWith(outputDetails.map(value => value.buildAwsValue()))(
        _.outputDetails
      )
      .optionallyWith(
        traceHeader.map(value => TraceHeader.unwrap(value): java.lang.String)
      )(_.traceHeader)
      .optionallyWith(
        mapRunArn.map(value => LongArn.unwrap(value): java.lang.String)
      )(_.mapRunArn)
      .optionallyWith(
        error.map(value => SensitiveError.unwrap(value): java.lang.String)
      )(_.error)
      .optionallyWith(
        cause.map(value => SensitiveCause.unwrap(value): java.lang.String)
      )(_.cause)
      .optionallyWith(
        stateMachineVersionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.stateMachineVersionArn)
      .optionallyWith(
        stateMachineAliasArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.stateMachineAliasArn)
      .optionallyWith(
        redriveCount.map(value => RedriveCount.unwrap(value): Integer)
      )(_.redriveCount)
      .optionallyWith(
        redriveDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.redriveDate)
      .optionallyWith(redriveStatus.map(value => value.unwrap))(_.redriveStatus)
      .optionallyWith(
        redriveStatusReason.map(value =>
          SensitiveData.unwrap(value): java.lang.String
        )
      )(_.redriveStatusReason)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.DescribeExecutionResponse.ReadOnly =
    zio.aws.sfn.model.DescribeExecutionResponse.wrap(buildAwsValue())
}
object DescribeExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.DescribeExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.DescribeExecutionResponse =
      zio.aws.sfn.model.DescribeExecutionResponse(
        executionArn,
        stateMachineArn,
        name.map(value => value),
        status,
        startDate,
        stopDate.map(value => value),
        input.map(value => value),
        inputDetails.map(value => value.asEditable),
        output.map(value => value),
        outputDetails.map(value => value.asEditable),
        traceHeader.map(value => value),
        mapRunArn.map(value => value),
        error.map(value => value),
        cause.map(value => value),
        stateMachineVersionArn.map(value => value),
        stateMachineAliasArn.map(value => value),
        redriveCount.map(value => value),
        redriveDate.map(value => value),
        redriveStatus.map(value => value),
        redriveStatusReason.map(value => value)
      )
    def executionArn: Arn
    def stateMachineArn: Arn
    def name: Optional[Name]
    def status: zio.aws.sfn.model.ExecutionStatus
    def startDate: Timestamp
    def stopDate: Optional[Timestamp]
    def input: Optional[SensitiveData]
    def inputDetails: Optional[
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.ReadOnly
    ]
    def output: Optional[SensitiveData]
    def outputDetails: Optional[
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.ReadOnly
    ]
    def traceHeader: Optional[TraceHeader]
    def mapRunArn: Optional[LongArn]
    def error: Optional[SensitiveError]
    def cause: Optional[SensitiveCause]
    def stateMachineVersionArn: Optional[Arn]
    def stateMachineAliasArn: Optional[Arn]
    def redriveCount: Optional[RedriveCount]
    def redriveDate: Optional[Timestamp]
    def redriveStatus: Optional[zio.aws.sfn.model.ExecutionRedriveStatus]
    def redriveStatusReason: Optional[SensitiveData]
    def getExecutionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(executionArn)
    def getStateMachineArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineArn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, Nothing, zio.aws.sfn.model.ExecutionStatus] =
      ZIO.succeed(status)
    def getStartDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startDate)
    def getStopDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("stopDate", stopDate)
    def getInput: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("input", input)
    def getInputDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.ReadOnly
    ] = AwsError.unwrapOptionField("inputDetails", inputDetails)
    def getOutput: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("output", output)
    def getOutputDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.ReadOnly
    ] = AwsError.unwrapOptionField("outputDetails", outputDetails)
    def getTraceHeader: ZIO[Any, AwsError, TraceHeader] =
      AwsError.unwrapOptionField("traceHeader", traceHeader)
    def getMapRunArn: ZIO[Any, AwsError, LongArn] =
      AwsError.unwrapOptionField("mapRunArn", mapRunArn)
    def getError: ZIO[Any, AwsError, SensitiveError] =
      AwsError.unwrapOptionField("error", error)
    def getCause: ZIO[Any, AwsError, SensitiveCause] =
      AwsError.unwrapOptionField("cause", cause)
    def getStateMachineVersionArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("stateMachineVersionArn", stateMachineVersionArn)
    def getStateMachineAliasArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("stateMachineAliasArn", stateMachineAliasArn)
    def getRedriveCount: ZIO[Any, AwsError, RedriveCount] =
      AwsError.unwrapOptionField("redriveCount", redriveCount)
    def getRedriveDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("redriveDate", redriveDate)
    def getRedriveStatus
        : ZIO[Any, AwsError, zio.aws.sfn.model.ExecutionRedriveStatus] =
      AwsError.unwrapOptionField("redriveStatus", redriveStatus)
    def getRedriveStatusReason: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("redriveStatusReason", redriveStatusReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.DescribeExecutionResponse
  ) extends zio.aws.sfn.model.DescribeExecutionResponse.ReadOnly {
    override val executionArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.executionArn())
    override val stateMachineArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineArn())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.sfn.model.primitives.Name(value))
    override val status: zio.aws.sfn.model.ExecutionStatus =
      zio.aws.sfn.model.ExecutionStatus.wrap(impl.status())
    override val startDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.startDate())
    override val stopDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.stopDate())
      .map(value => zio.aws.sfn.model.primitives.Timestamp(value))
    override val input: Optional[SensitiveData] = zio.aws.core.internal
      .optionalFromNullable(impl.input())
      .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val inputDetails: Optional[
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputDetails())
      .map(value =>
        zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.wrap(value)
      )
    override val output: Optional[SensitiveData] = zio.aws.core.internal
      .optionalFromNullable(impl.output())
      .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val outputDetails: Optional[
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputDetails())
      .map(value =>
        zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.wrap(value)
      )
    override val traceHeader: Optional[TraceHeader] = zio.aws.core.internal
      .optionalFromNullable(impl.traceHeader())
      .map(value => zio.aws.sfn.model.primitives.TraceHeader(value))
    override val mapRunArn: Optional[LongArn] = zio.aws.core.internal
      .optionalFromNullable(impl.mapRunArn())
      .map(value => zio.aws.sfn.model.primitives.LongArn(value))
    override val error: Optional[SensitiveError] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value => zio.aws.sfn.model.primitives.SensitiveError(value))
    override val cause: Optional[SensitiveCause] = zio.aws.core.internal
      .optionalFromNullable(impl.cause())
      .map(value => zio.aws.sfn.model.primitives.SensitiveCause(value))
    override val stateMachineVersionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.stateMachineVersionArn())
      .map(value => zio.aws.sfn.model.primitives.Arn(value))
    override val stateMachineAliasArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.stateMachineAliasArn())
      .map(value => zio.aws.sfn.model.primitives.Arn(value))
    override val redriveCount: Optional[RedriveCount] = zio.aws.core.internal
      .optionalFromNullable(impl.redriveCount())
      .map(value => zio.aws.sfn.model.primitives.RedriveCount(value))
    override val redriveDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.redriveDate())
      .map(value => zio.aws.sfn.model.primitives.Timestamp(value))
    override val redriveStatus
        : Optional[zio.aws.sfn.model.ExecutionRedriveStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.redriveStatus())
        .map(value => zio.aws.sfn.model.ExecutionRedriveStatus.wrap(value))
    override val redriveStatusReason: Optional[SensitiveData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.redriveStatusReason())
        .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.DescribeExecutionResponse
  ): zio.aws.sfn.model.DescribeExecutionResponse.ReadOnly = new Wrapper(impl)
}
