package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.LongArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeMapRunRequest(mapRunArn: LongArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.DescribeMapRunRequest = {
    import DescribeMapRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.DescribeMapRunRequest
      .builder()
      .mapRunArn(LongArn.unwrap(mapRunArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.DescribeMapRunRequest.ReadOnly =
    zio.aws.sfn.model.DescribeMapRunRequest.wrap(buildAwsValue())
}
object DescribeMapRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.DescribeMapRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.DescribeMapRunRequest =
      zio.aws.sfn.model.DescribeMapRunRequest(mapRunArn)
    def mapRunArn: LongArn
    def getMapRunArn: ZIO[Any, Nothing, LongArn] = ZIO.succeed(mapRunArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.DescribeMapRunRequest
  ) extends zio.aws.sfn.model.DescribeMapRunRequest.ReadOnly {
    override val mapRunArn: LongArn =
      zio.aws.sfn.model.primitives.LongArn(impl.mapRunArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.DescribeMapRunRequest
  ): zio.aws.sfn.model.DescribeMapRunRequest.ReadOnly = new Wrapper(impl)
}
