package zio.aws.sfn.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{
  LongArn,
  ToleratedFailurePercentage,
  RedriveCount,
  Timestamp,
  Arn,
  MaxConcurrency,
  ToleratedFailureCount
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeMapRunResponse(
    mapRunArn: LongArn,
    executionArn: Arn,
    status: zio.aws.sfn.model.MapRunStatus,
    startDate: Timestamp,
    stopDate: Optional[Timestamp] = Optional.Absent,
    maxConcurrency: MaxConcurrency,
    toleratedFailurePercentage: ToleratedFailurePercentage,
    toleratedFailureCount: ToleratedFailureCount,
    itemCounts: zio.aws.sfn.model.MapRunItemCounts,
    executionCounts: zio.aws.sfn.model.MapRunExecutionCounts,
    redriveCount: Optional[RedriveCount] = Optional.Absent,
    redriveDate: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.DescribeMapRunResponse = {
    import DescribeMapRunResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.DescribeMapRunResponse
      .builder()
      .mapRunArn(LongArn.unwrap(mapRunArn): java.lang.String)
      .executionArn(Arn.unwrap(executionArn): java.lang.String)
      .status(status.unwrap)
      .startDate(Timestamp.unwrap(startDate): Instant)
      .optionallyWith(stopDate.map(value => Timestamp.unwrap(value): Instant))(
        _.stopDate
      )
      .maxConcurrency(MaxConcurrency.unwrap(maxConcurrency): Integer)
      .toleratedFailurePercentage(
        ToleratedFailurePercentage.unwrap(
          toleratedFailurePercentage
        ): java.lang.Float
      )
      .toleratedFailureCount(
        ToleratedFailureCount.unwrap(toleratedFailureCount): java.lang.Long
      )
      .itemCounts(itemCounts.buildAwsValue())
      .executionCounts(executionCounts.buildAwsValue())
      .optionallyWith(
        redriveCount.map(value => RedriveCount.unwrap(value): Integer)
      )(_.redriveCount)
      .optionallyWith(
        redriveDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.redriveDate)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.DescribeMapRunResponse.ReadOnly =
    zio.aws.sfn.model.DescribeMapRunResponse.wrap(buildAwsValue())
}
object DescribeMapRunResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.DescribeMapRunResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.DescribeMapRunResponse =
      zio.aws.sfn.model.DescribeMapRunResponse(
        mapRunArn,
        executionArn,
        status,
        startDate,
        stopDate.map(value => value),
        maxConcurrency,
        toleratedFailurePercentage,
        toleratedFailureCount,
        itemCounts.asEditable,
        executionCounts.asEditable,
        redriveCount.map(value => value),
        redriveDate.map(value => value)
      )
    def mapRunArn: LongArn
    def executionArn: Arn
    def status: zio.aws.sfn.model.MapRunStatus
    def startDate: Timestamp
    def stopDate: Optional[Timestamp]
    def maxConcurrency: MaxConcurrency
    def toleratedFailurePercentage: ToleratedFailurePercentage
    def toleratedFailureCount: ToleratedFailureCount
    def itemCounts: zio.aws.sfn.model.MapRunItemCounts.ReadOnly
    def executionCounts: zio.aws.sfn.model.MapRunExecutionCounts.ReadOnly
    def redriveCount: Optional[RedriveCount]
    def redriveDate: Optional[Timestamp]
    def getMapRunArn: ZIO[Any, Nothing, LongArn] = ZIO.succeed(mapRunArn)
    def getExecutionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(executionArn)
    def getStatus: ZIO[Any, Nothing, zio.aws.sfn.model.MapRunStatus] =
      ZIO.succeed(status)
    def getStartDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startDate)
    def getStopDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("stopDate", stopDate)
    def getMaxConcurrency: ZIO[Any, Nothing, MaxConcurrency] =
      ZIO.succeed(maxConcurrency)
    def getToleratedFailurePercentage
        : ZIO[Any, Nothing, ToleratedFailurePercentage] =
      ZIO.succeed(toleratedFailurePercentage)
    def getToleratedFailureCount: ZIO[Any, Nothing, ToleratedFailureCount] =
      ZIO.succeed(toleratedFailureCount)
    def getItemCounts
        : ZIO[Any, Nothing, zio.aws.sfn.model.MapRunItemCounts.ReadOnly] =
      ZIO.succeed(itemCounts)
    def getExecutionCounts
        : ZIO[Any, Nothing, zio.aws.sfn.model.MapRunExecutionCounts.ReadOnly] =
      ZIO.succeed(executionCounts)
    def getRedriveCount: ZIO[Any, AwsError, RedriveCount] =
      AwsError.unwrapOptionField("redriveCount", redriveCount)
    def getRedriveDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("redriveDate", redriveDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.DescribeMapRunResponse
  ) extends zio.aws.sfn.model.DescribeMapRunResponse.ReadOnly {
    override val mapRunArn: LongArn =
      zio.aws.sfn.model.primitives.LongArn(impl.mapRunArn())
    override val executionArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.executionArn())
    override val status: zio.aws.sfn.model.MapRunStatus =
      zio.aws.sfn.model.MapRunStatus.wrap(impl.status())
    override val startDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.startDate())
    override val stopDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.stopDate())
      .map(value => zio.aws.sfn.model.primitives.Timestamp(value))
    override val maxConcurrency: MaxConcurrency =
      zio.aws.sfn.model.primitives.MaxConcurrency(impl.maxConcurrency())
    override val toleratedFailurePercentage: ToleratedFailurePercentage =
      zio.aws.sfn.model.primitives
        .ToleratedFailurePercentage(impl.toleratedFailurePercentage())
    override val toleratedFailureCount: ToleratedFailureCount =
      zio.aws.sfn.model.primitives
        .ToleratedFailureCount(impl.toleratedFailureCount())
    override val itemCounts: zio.aws.sfn.model.MapRunItemCounts.ReadOnly =
      zio.aws.sfn.model.MapRunItemCounts.wrap(impl.itemCounts())
    override val executionCounts
        : zio.aws.sfn.model.MapRunExecutionCounts.ReadOnly =
      zio.aws.sfn.model.MapRunExecutionCounts.wrap(impl.executionCounts())
    override val redriveCount: Optional[RedriveCount] = zio.aws.core.internal
      .optionalFromNullable(impl.redriveCount())
      .map(value => zio.aws.sfn.model.primitives.RedriveCount(value))
    override val redriveDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.redriveDate())
      .map(value => zio.aws.sfn.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.DescribeMapRunResponse
  ): zio.aws.sfn.model.DescribeMapRunResponse.ReadOnly = new Wrapper(impl)
}
