package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeStateMachineAliasRequest(stateMachineAliasArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.DescribeStateMachineAliasRequest = {
    import DescribeStateMachineAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.DescribeStateMachineAliasRequest
      .builder()
      .stateMachineAliasArn(Arn.unwrap(stateMachineAliasArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.DescribeStateMachineAliasRequest.ReadOnly =
    zio.aws.sfn.model.DescribeStateMachineAliasRequest.wrap(buildAwsValue())
}
object DescribeStateMachineAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.DescribeStateMachineAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.DescribeStateMachineAliasRequest =
      zio.aws.sfn.model.DescribeStateMachineAliasRequest(stateMachineAliasArn)
    def stateMachineAliasArn: Arn
    def getStateMachineAliasArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineAliasArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.DescribeStateMachineAliasRequest
  ) extends zio.aws.sfn.model.DescribeStateMachineAliasRequest.ReadOnly {
    override val stateMachineAliasArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineAliasArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.DescribeStateMachineAliasRequest
  ): zio.aws.sfn.model.DescribeStateMachineAliasRequest.ReadOnly = new Wrapper(
    impl
  )
}
