package zio.aws.sfn.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{Timestamp, AliasDescription, Name, Arn}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeStateMachineAliasResponse(
    stateMachineAliasArn: Optional[Arn] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    description: Optional[AliasDescription] = Optional.Absent,
    routingConfiguration: Optional[
      Iterable[zio.aws.sfn.model.RoutingConfigurationListItem]
    ] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    updateDate: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.DescribeStateMachineAliasResponse = {
    import DescribeStateMachineAliasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.DescribeStateMachineAliasResponse
      .builder()
      .optionallyWith(
        stateMachineAliasArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.stateMachineAliasArn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value =>
          AliasDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        routingConfiguration.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routingConfiguration)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        updateDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.updateDate)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.DescribeStateMachineAliasResponse.ReadOnly =
    zio.aws.sfn.model.DescribeStateMachineAliasResponse.wrap(buildAwsValue())
}
object DescribeStateMachineAliasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.DescribeStateMachineAliasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.DescribeStateMachineAliasResponse =
      zio.aws.sfn.model.DescribeStateMachineAliasResponse(
        stateMachineAliasArn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        routingConfiguration.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationDate.map(value => value),
        updateDate.map(value => value)
      )
    def stateMachineAliasArn: Optional[Arn]
    def name: Optional[Name]
    def description: Optional[AliasDescription]
    def routingConfiguration: Optional[
      List[zio.aws.sfn.model.RoutingConfigurationListItem.ReadOnly]
    ]
    def creationDate: Optional[Timestamp]
    def updateDate: Optional[Timestamp]
    def getStateMachineAliasArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("stateMachineAliasArn", stateMachineAliasArn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, AliasDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRoutingConfiguration: ZIO[Any, AwsError, List[
      zio.aws.sfn.model.RoutingConfigurationListItem.ReadOnly
    ]] =
      AwsError.unwrapOptionField("routingConfiguration", routingConfiguration)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getUpdateDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updateDate", updateDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.DescribeStateMachineAliasResponse
  ) extends zio.aws.sfn.model.DescribeStateMachineAliasResponse.ReadOnly {
    override val stateMachineAliasArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.stateMachineAliasArn())
      .map(value => zio.aws.sfn.model.primitives.Arn(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.sfn.model.primitives.Name(value))
    override val description: Optional[AliasDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.sfn.model.primitives.AliasDescription(value))
    override val routingConfiguration: Optional[
      List[zio.aws.sfn.model.RoutingConfigurationListItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.routingConfiguration())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sfn.model.RoutingConfigurationListItem.wrap(item)
        }.toList
      )
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.sfn.model.primitives.Timestamp(value))
    override val updateDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updateDate())
      .map(value => zio.aws.sfn.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.DescribeStateMachineAliasResponse
  ): zio.aws.sfn.model.DescribeStateMachineAliasResponse.ReadOnly = new Wrapper(
    impl
  )
}
