package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeStateMachineRequest(
    stateMachineArn: Arn,
    includedData: Optional[zio.aws.sfn.model.IncludedData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.DescribeStateMachineRequest = {
    import DescribeStateMachineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.DescribeStateMachineRequest
      .builder()
      .stateMachineArn(Arn.unwrap(stateMachineArn): java.lang.String)
      .optionallyWith(includedData.map(value => value.unwrap))(_.includedData)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.DescribeStateMachineRequest.ReadOnly =
    zio.aws.sfn.model.DescribeStateMachineRequest.wrap(buildAwsValue())
}
object DescribeStateMachineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.DescribeStateMachineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.DescribeStateMachineRequest =
      zio.aws.sfn.model.DescribeStateMachineRequest(
        stateMachineArn,
        includedData.map(value => value)
      )
    def stateMachineArn: Arn
    def includedData: Optional[zio.aws.sfn.model.IncludedData]
    def getStateMachineArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineArn)
    def getIncludedData: ZIO[Any, AwsError, zio.aws.sfn.model.IncludedData] =
      AwsError.unwrapOptionField("includedData", includedData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.DescribeStateMachineRequest
  ) extends zio.aws.sfn.model.DescribeStateMachineRequest.ReadOnly {
    override val stateMachineArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineArn())
    override val includedData: Optional[zio.aws.sfn.model.IncludedData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includedData())
        .map(value => zio.aws.sfn.model.IncludedData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.DescribeStateMachineRequest
  ): zio.aws.sfn.model.DescribeStateMachineRequest.ReadOnly = new Wrapper(impl)
}
