package zio.aws.sfn.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{
  Timestamp,
  RevisionId,
  Arn,
  Definition,
  Name,
  VersionDescription,
  MapRunLabel
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeStateMachineResponse(
    stateMachineArn: Arn,
    name: Name,
    status: Optional[zio.aws.sfn.model.StateMachineStatus] = Optional.Absent,
    definition: Definition,
    roleArn: Arn,
    `type`: zio.aws.sfn.model.StateMachineType,
    creationDate: Timestamp,
    loggingConfiguration: Optional[zio.aws.sfn.model.LoggingConfiguration] =
      Optional.Absent,
    tracingConfiguration: Optional[zio.aws.sfn.model.TracingConfiguration] =
      Optional.Absent,
    label: Optional[MapRunLabel] = Optional.Absent,
    revisionId: Optional[RevisionId] = Optional.Absent,
    description: Optional[VersionDescription] = Optional.Absent,
    encryptionConfiguration: Optional[
      zio.aws.sfn.model.EncryptionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.DescribeStateMachineResponse = {
    import DescribeStateMachineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.DescribeStateMachineResponse
      .builder()
      .stateMachineArn(Arn.unwrap(stateMachineArn): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .definition(Definition.unwrap(definition): java.lang.String)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .`type`(`type`.unwrap)
      .creationDate(Timestamp.unwrap(creationDate): Instant)
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .optionallyWith(tracingConfiguration.map(value => value.buildAwsValue()))(
        _.tracingConfiguration
      )
      .optionallyWith(
        label.map(value => MapRunLabel.unwrap(value): java.lang.String)
      )(_.label)
      .optionallyWith(
        revisionId.map(value => RevisionId.unwrap(value): java.lang.String)
      )(_.revisionId)
      .optionallyWith(
        description.map(value =>
          VersionDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.DescribeStateMachineResponse.ReadOnly =
    zio.aws.sfn.model.DescribeStateMachineResponse.wrap(buildAwsValue())
}
object DescribeStateMachineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.DescribeStateMachineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.DescribeStateMachineResponse =
      zio.aws.sfn.model.DescribeStateMachineResponse(
        stateMachineArn,
        name,
        status.map(value => value),
        definition,
        roleArn,
        `type`,
        creationDate,
        loggingConfiguration.map(value => value.asEditable),
        tracingConfiguration.map(value => value.asEditable),
        label.map(value => value),
        revisionId.map(value => value),
        description.map(value => value),
        encryptionConfiguration.map(value => value.asEditable)
      )
    def stateMachineArn: Arn
    def name: Name
    def status: Optional[zio.aws.sfn.model.StateMachineStatus]
    def definition: Definition
    def roleArn: Arn
    def `type`: zio.aws.sfn.model.StateMachineType
    def creationDate: Timestamp
    def loggingConfiguration
        : Optional[zio.aws.sfn.model.LoggingConfiguration.ReadOnly]
    def tracingConfiguration
        : Optional[zio.aws.sfn.model.TracingConfiguration.ReadOnly]
    def label: Optional[MapRunLabel]
    def revisionId: Optional[RevisionId]
    def description: Optional[VersionDescription]
    def encryptionConfiguration
        : Optional[zio.aws.sfn.model.EncryptionConfiguration.ReadOnly]
    def getStateMachineArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineArn)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getStatus: ZIO[Any, AwsError, zio.aws.sfn.model.StateMachineStatus] =
      AwsError.unwrapOptionField("status", status)
    def getDefinition: ZIO[Any, Nothing, Definition] = ZIO.succeed(definition)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getType: ZIO[Any, Nothing, zio.aws.sfn.model.StateMachineType] =
      ZIO.succeed(`type`)
    def getCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDate)
    def getLoggingConfiguration
        : ZIO[Any, AwsError, zio.aws.sfn.model.LoggingConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
    def getTracingConfiguration
        : ZIO[Any, AwsError, zio.aws.sfn.model.TracingConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("tracingConfiguration", tracingConfiguration)
    def getLabel: ZIO[Any, AwsError, MapRunLabel] =
      AwsError.unwrapOptionField("label", label)
    def getRevisionId: ZIO[Any, AwsError, RevisionId] =
      AwsError.unwrapOptionField("revisionId", revisionId)
    def getDescription: ZIO[Any, AwsError, VersionDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.DescribeStateMachineResponse
  ) extends zio.aws.sfn.model.DescribeStateMachineResponse.ReadOnly {
    override val stateMachineArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineArn())
    override val name: Name = zio.aws.sfn.model.primitives.Name(impl.name())
    override val status: Optional[zio.aws.sfn.model.StateMachineStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sfn.model.StateMachineStatus.wrap(value))
    override val definition: Definition =
      zio.aws.sfn.model.primitives.Definition(impl.definition())
    override val roleArn: Arn = zio.aws.sfn.model.primitives.Arn(impl.roleArn())
    override val `type`: zio.aws.sfn.model.StateMachineType =
      zio.aws.sfn.model.StateMachineType.wrap(impl.`type`())
    override val creationDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.creationDate())
    override val loggingConfiguration
        : Optional[zio.aws.sfn.model.LoggingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingConfiguration())
        .map(value => zio.aws.sfn.model.LoggingConfiguration.wrap(value))
    override val tracingConfiguration
        : Optional[zio.aws.sfn.model.TracingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tracingConfiguration())
        .map(value => zio.aws.sfn.model.TracingConfiguration.wrap(value))
    override val label: Optional[MapRunLabel] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value => zio.aws.sfn.model.primitives.MapRunLabel(value))
    override val revisionId: Optional[RevisionId] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => zio.aws.sfn.model.primitives.RevisionId(value))
    override val description: Optional[VersionDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.sfn.model.primitives.VersionDescription(value))
    override val encryptionConfiguration
        : Optional[zio.aws.sfn.model.EncryptionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionConfiguration())
        .map(value => zio.aws.sfn.model.EncryptionConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.DescribeStateMachineResponse
  ): zio.aws.sfn.model.DescribeStateMachineResponse.ReadOnly = new Wrapper(impl)
}
