package zio.aws.sfn.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{KmsDataKeyReusePeriodSeconds, KmsKeyId}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class EncryptionConfiguration(
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    kmsDataKeyReusePeriodSeconds: Optional[KmsDataKeyReusePeriodSeconds] =
      Optional.Absent,
    `type`: zio.aws.sfn.model.EncryptionType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.EncryptionConfiguration = {
    import EncryptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.EncryptionConfiguration
      .builder()
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        kmsDataKeyReusePeriodSeconds.map(value =>
          KmsDataKeyReusePeriodSeconds.unwrap(value): Integer
        )
      )(_.kmsDataKeyReusePeriodSeconds)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.EncryptionConfiguration.ReadOnly =
    zio.aws.sfn.model.EncryptionConfiguration.wrap(buildAwsValue())
}
object EncryptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.EncryptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.EncryptionConfiguration =
      zio.aws.sfn.model.EncryptionConfiguration(
        kmsKeyId.map(value => value),
        kmsDataKeyReusePeriodSeconds.map(value => value),
        `type`
      )
    def kmsKeyId: Optional[KmsKeyId]
    def kmsDataKeyReusePeriodSeconds: Optional[KmsDataKeyReusePeriodSeconds]
    def `type`: zio.aws.sfn.model.EncryptionType
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getKmsDataKeyReusePeriodSeconds
        : ZIO[Any, AwsError, KmsDataKeyReusePeriodSeconds] =
      AwsError.unwrapOptionField(
        "kmsDataKeyReusePeriodSeconds",
        kmsDataKeyReusePeriodSeconds
      )
    def getType: ZIO[Any, Nothing, zio.aws.sfn.model.EncryptionType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.EncryptionConfiguration
  ) extends zio.aws.sfn.model.EncryptionConfiguration.ReadOnly {
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sfn.model.primitives.KmsKeyId(value))
    override val kmsDataKeyReusePeriodSeconds
        : Optional[KmsDataKeyReusePeriodSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsDataKeyReusePeriodSeconds())
      .map(value =>
        zio.aws.sfn.model.primitives.KmsDataKeyReusePeriodSeconds(value)
      )
    override val `type`: zio.aws.sfn.model.EncryptionType =
      zio.aws.sfn.model.EncryptionType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.EncryptionConfiguration
  ): zio.aws.sfn.model.EncryptionConfiguration.ReadOnly = new Wrapper(impl)
}
