package zio.aws.sfn.model
import scala.jdk.CollectionConverters._
sealed trait EncryptionType {
  def unwrap: software.amazon.awssdk.services.sfn.model.EncryptionType
}
object EncryptionType {
  def wrap(
      value: software.amazon.awssdk.services.sfn.model.EncryptionType
  ): zio.aws.sfn.model.EncryptionType = value match {
    case software.amazon.awssdk.services.sfn.model.EncryptionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sfn.model.EncryptionType.AWS_OWNED_KEY =>
      val r = AWS_OWNED_KEY
      r
    case software.amazon.awssdk.services.sfn.model.EncryptionType.CUSTOMER_MANAGED_KMS_KEY =>
      val r = CUSTOMER_MANAGED_KMS_KEY
      r
  }
  case object unknownToSdkVersion extends zio.aws.sfn.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.EncryptionType =
      software.amazon.awssdk.services.sfn.model.EncryptionType.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_OWNED_KEY extends zio.aws.sfn.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.EncryptionType =
      software.amazon.awssdk.services.sfn.model.EncryptionType.AWS_OWNED_KEY
  }
  case object CUSTOMER_MANAGED_KMS_KEY
      extends zio.aws.sfn.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.EncryptionType =
      software.amazon.awssdk.services.sfn.model.EncryptionType.CUSTOMER_MANAGED_KMS_KEY
  }
}
