package zio.aws.sfn.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{
  LongArn,
  UnsignedInteger,
  RedriveCount,
  Timestamp,
  Arn,
  Name
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ExecutionListItem(
    executionArn: Arn,
    stateMachineArn: Arn,
    name: Name,
    status: zio.aws.sfn.model.ExecutionStatus,
    startDate: Timestamp,
    stopDate: Optional[Timestamp] = Optional.Absent,
    mapRunArn: Optional[LongArn] = Optional.Absent,
    itemCount: Optional[UnsignedInteger] = Optional.Absent,
    stateMachineVersionArn: Optional[Arn] = Optional.Absent,
    stateMachineAliasArn: Optional[Arn] = Optional.Absent,
    redriveCount: Optional[RedriveCount] = Optional.Absent,
    redriveDate: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ExecutionListItem = {
    import ExecutionListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ExecutionListItem
      .builder()
      .executionArn(Arn.unwrap(executionArn): java.lang.String)
      .stateMachineArn(Arn.unwrap(stateMachineArn): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .status(status.unwrap)
      .startDate(Timestamp.unwrap(startDate): Instant)
      .optionallyWith(stopDate.map(value => Timestamp.unwrap(value): Instant))(
        _.stopDate
      )
      .optionallyWith(
        mapRunArn.map(value => LongArn.unwrap(value): java.lang.String)
      )(_.mapRunArn)
      .optionallyWith(
        itemCount.map(value => UnsignedInteger.unwrap(value): Integer)
      )(_.itemCount)
      .optionallyWith(
        stateMachineVersionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.stateMachineVersionArn)
      .optionallyWith(
        stateMachineAliasArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.stateMachineAliasArn)
      .optionallyWith(
        redriveCount.map(value => RedriveCount.unwrap(value): Integer)
      )(_.redriveCount)
      .optionallyWith(
        redriveDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.redriveDate)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.ExecutionListItem.ReadOnly =
    zio.aws.sfn.model.ExecutionListItem.wrap(buildAwsValue())
}
object ExecutionListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ExecutionListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ExecutionListItem =
      zio.aws.sfn.model.ExecutionListItem(
        executionArn,
        stateMachineArn,
        name,
        status,
        startDate,
        stopDate.map(value => value),
        mapRunArn.map(value => value),
        itemCount.map(value => value),
        stateMachineVersionArn.map(value => value),
        stateMachineAliasArn.map(value => value),
        redriveCount.map(value => value),
        redriveDate.map(value => value)
      )
    def executionArn: Arn
    def stateMachineArn: Arn
    def name: Name
    def status: zio.aws.sfn.model.ExecutionStatus
    def startDate: Timestamp
    def stopDate: Optional[Timestamp]
    def mapRunArn: Optional[LongArn]
    def itemCount: Optional[UnsignedInteger]
    def stateMachineVersionArn: Optional[Arn]
    def stateMachineAliasArn: Optional[Arn]
    def redriveCount: Optional[RedriveCount]
    def redriveDate: Optional[Timestamp]
    def getExecutionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(executionArn)
    def getStateMachineArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineArn)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getStatus: ZIO[Any, Nothing, zio.aws.sfn.model.ExecutionStatus] =
      ZIO.succeed(status)
    def getStartDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startDate)
    def getStopDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("stopDate", stopDate)
    def getMapRunArn: ZIO[Any, AwsError, LongArn] =
      AwsError.unwrapOptionField("mapRunArn", mapRunArn)
    def getItemCount: ZIO[Any, AwsError, UnsignedInteger] =
      AwsError.unwrapOptionField("itemCount", itemCount)
    def getStateMachineVersionArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("stateMachineVersionArn", stateMachineVersionArn)
    def getStateMachineAliasArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("stateMachineAliasArn", stateMachineAliasArn)
    def getRedriveCount: ZIO[Any, AwsError, RedriveCount] =
      AwsError.unwrapOptionField("redriveCount", redriveCount)
    def getRedriveDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("redriveDate", redriveDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ExecutionListItem
  ) extends zio.aws.sfn.model.ExecutionListItem.ReadOnly {
    override val executionArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.executionArn())
    override val stateMachineArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineArn())
    override val name: Name = zio.aws.sfn.model.primitives.Name(impl.name())
    override val status: zio.aws.sfn.model.ExecutionStatus =
      zio.aws.sfn.model.ExecutionStatus.wrap(impl.status())
    override val startDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.startDate())
    override val stopDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.stopDate())
      .map(value => zio.aws.sfn.model.primitives.Timestamp(value))
    override val mapRunArn: Optional[LongArn] = zio.aws.core.internal
      .optionalFromNullable(impl.mapRunArn())
      .map(value => zio.aws.sfn.model.primitives.LongArn(value))
    override val itemCount: Optional[UnsignedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.itemCount())
      .map(value => zio.aws.sfn.model.primitives.UnsignedInteger(value))
    override val stateMachineVersionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.stateMachineVersionArn())
      .map(value => zio.aws.sfn.model.primitives.Arn(value))
    override val stateMachineAliasArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.stateMachineAliasArn())
      .map(value => zio.aws.sfn.model.primitives.Arn(value))
    override val redriveCount: Optional[RedriveCount] = zio.aws.core.internal
      .optionalFromNullable(impl.redriveCount())
      .map(value => zio.aws.sfn.model.primitives.RedriveCount(value))
    override val redriveDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.redriveDate())
      .map(value => zio.aws.sfn.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ExecutionListItem
  ): zio.aws.sfn.model.ExecutionListItem.ReadOnly = new Wrapper(impl)
}
