package zio.aws.sfn.model
import scala.jdk.CollectionConverters._
sealed trait ExecutionRedriveFilter {
  def unwrap: software.amazon.awssdk.services.sfn.model.ExecutionRedriveFilter
}
object ExecutionRedriveFilter {
  def wrap(
      value: software.amazon.awssdk.services.sfn.model.ExecutionRedriveFilter
  ): zio.aws.sfn.model.ExecutionRedriveFilter = value match {
    case software.amazon.awssdk.services.sfn.model.ExecutionRedriveFilter.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sfn.model.ExecutionRedriveFilter.REDRIVEN =>
      val r = REDRIVEN
      r
    case software.amazon.awssdk.services.sfn.model.ExecutionRedriveFilter.NOT_REDRIVEN =>
      val r = NOT_REDRIVEN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sfn.model.ExecutionRedriveFilter {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.ExecutionRedriveFilter =
      software.amazon.awssdk.services.sfn.model.ExecutionRedriveFilter.UNKNOWN_TO_SDK_VERSION
  }
  case object REDRIVEN extends zio.aws.sfn.model.ExecutionRedriveFilter {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.ExecutionRedriveFilter =
      software.amazon.awssdk.services.sfn.model.ExecutionRedriveFilter.REDRIVEN
  }
  case object NOT_REDRIVEN extends zio.aws.sfn.model.ExecutionRedriveFilter {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.ExecutionRedriveFilter =
      software.amazon.awssdk.services.sfn.model.ExecutionRedriveFilter.NOT_REDRIVEN
  }
}
