package zio.aws.sfn.model
import scala.jdk.CollectionConverters._
sealed trait ExecutionRedriveStatus {
  def unwrap: software.amazon.awssdk.services.sfn.model.ExecutionRedriveStatus
}
object ExecutionRedriveStatus {
  def wrap(
      value: software.amazon.awssdk.services.sfn.model.ExecutionRedriveStatus
  ): zio.aws.sfn.model.ExecutionRedriveStatus = value match {
    case software.amazon.awssdk.services.sfn.model.ExecutionRedriveStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sfn.model.ExecutionRedriveStatus.REDRIVABLE =>
      val r = REDRIVABLE
      r
    case software.amazon.awssdk.services.sfn.model.ExecutionRedriveStatus.NOT_REDRIVABLE =>
      val r = NOT_REDRIVABLE
      r
    case software.amazon.awssdk.services.sfn.model.ExecutionRedriveStatus.REDRIVABLE_BY_MAP_RUN =>
      val r = REDRIVABLE_BY_MAP_RUN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sfn.model.ExecutionRedriveStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.ExecutionRedriveStatus =
      software.amazon.awssdk.services.sfn.model.ExecutionRedriveStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object REDRIVABLE extends zio.aws.sfn.model.ExecutionRedriveStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.ExecutionRedriveStatus =
      software.amazon.awssdk.services.sfn.model.ExecutionRedriveStatus.REDRIVABLE
  }
  case object NOT_REDRIVABLE extends zio.aws.sfn.model.ExecutionRedriveStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.ExecutionRedriveStatus =
      software.amazon.awssdk.services.sfn.model.ExecutionRedriveStatus.NOT_REDRIVABLE
  }
  case object REDRIVABLE_BY_MAP_RUN
      extends zio.aws.sfn.model.ExecutionRedriveStatus {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.ExecutionRedriveStatus =
      software.amazon.awssdk.services.sfn.model.ExecutionRedriveStatus.REDRIVABLE_BY_MAP_RUN
  }
}
