package zio.aws.sfn.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.RedriveCount
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ExecutionRedrivenEventDetails(
    redriveCount: Optional[RedriveCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ExecutionRedrivenEventDetails = {
    import ExecutionRedrivenEventDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ExecutionRedrivenEventDetails
      .builder()
      .optionallyWith(
        redriveCount.map(value => RedriveCount.unwrap(value): Integer)
      )(_.redriveCount)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.ExecutionRedrivenEventDetails.ReadOnly =
    zio.aws.sfn.model.ExecutionRedrivenEventDetails.wrap(buildAwsValue())
}
object ExecutionRedrivenEventDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ExecutionRedrivenEventDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ExecutionRedrivenEventDetails =
      zio.aws.sfn.model
        .ExecutionRedrivenEventDetails(redriveCount.map(value => value))
    def redriveCount: Optional[RedriveCount]
    def getRedriveCount: ZIO[Any, AwsError, RedriveCount] =
      AwsError.unwrapOptionField("redriveCount", redriveCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ExecutionRedrivenEventDetails
  ) extends zio.aws.sfn.model.ExecutionRedrivenEventDetails.ReadOnly {
    override val redriveCount: Optional[RedriveCount] = zio.aws.core.internal
      .optionalFromNullable(impl.redriveCount())
      .map(value => zio.aws.sfn.model.primitives.RedriveCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ExecutionRedrivenEventDetails
  ): zio.aws.sfn.model.ExecutionRedrivenEventDetails.ReadOnly = new Wrapper(
    impl
  )
}
