package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{Arn, SensitiveData}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExecutionStartedEventDetails(
    input: Optional[SensitiveData] = Optional.Absent,
    inputDetails: Optional[zio.aws.sfn.model.HistoryEventExecutionDataDetails] =
      Optional.Absent,
    roleArn: Optional[Arn] = Optional.Absent,
    stateMachineAliasArn: Optional[Arn] = Optional.Absent,
    stateMachineVersionArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ExecutionStartedEventDetails = {
    import ExecutionStartedEventDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ExecutionStartedEventDetails
      .builder()
      .optionallyWith(
        input.map(value => SensitiveData.unwrap(value): java.lang.String)
      )(_.input)
      .optionallyWith(inputDetails.map(value => value.buildAwsValue()))(
        _.inputDetails
      )
      .optionallyWith(
        roleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        stateMachineAliasArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.stateMachineAliasArn)
      .optionallyWith(
        stateMachineVersionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.stateMachineVersionArn)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.ExecutionStartedEventDetails.ReadOnly =
    zio.aws.sfn.model.ExecutionStartedEventDetails.wrap(buildAwsValue())
}
object ExecutionStartedEventDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ExecutionStartedEventDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ExecutionStartedEventDetails =
      zio.aws.sfn.model.ExecutionStartedEventDetails(
        input.map(value => value),
        inputDetails.map(value => value.asEditable),
        roleArn.map(value => value),
        stateMachineAliasArn.map(value => value),
        stateMachineVersionArn.map(value => value)
      )
    def input: Optional[SensitiveData]
    def inputDetails
        : Optional[zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly]
    def roleArn: Optional[Arn]
    def stateMachineAliasArn: Optional[Arn]
    def stateMachineVersionArn: Optional[Arn]
    def getInput: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("input", input)
    def getInputDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly
    ] = AwsError.unwrapOptionField("inputDetails", inputDetails)
    def getRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getStateMachineAliasArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("stateMachineAliasArn", stateMachineAliasArn)
    def getStateMachineVersionArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("stateMachineVersionArn", stateMachineVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ExecutionStartedEventDetails
  ) extends zio.aws.sfn.model.ExecutionStartedEventDetails.ReadOnly {
    override val input: Optional[SensitiveData] = zio.aws.core.internal
      .optionalFromNullable(impl.input())
      .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val inputDetails: Optional[
      zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputDetails())
      .map(value =>
        zio.aws.sfn.model.HistoryEventExecutionDataDetails.wrap(value)
      )
    override val roleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.sfn.model.primitives.Arn(value))
    override val stateMachineAliasArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.stateMachineAliasArn())
      .map(value => zio.aws.sfn.model.primitives.Arn(value))
    override val stateMachineVersionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.stateMachineVersionArn())
      .map(value => zio.aws.sfn.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ExecutionStartedEventDetails
  ): zio.aws.sfn.model.ExecutionStartedEventDetails.ReadOnly = new Wrapper(impl)
}
