package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.SensitiveData
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExecutionSucceededEventDetails(
    output: Optional[SensitiveData] = Optional.Absent,
    outputDetails: Optional[
      zio.aws.sfn.model.HistoryEventExecutionDataDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ExecutionSucceededEventDetails = {
    import ExecutionSucceededEventDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ExecutionSucceededEventDetails
      .builder()
      .optionallyWith(
        output.map(value => SensitiveData.unwrap(value): java.lang.String)
      )(_.output)
      .optionallyWith(outputDetails.map(value => value.buildAwsValue()))(
        _.outputDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.ExecutionSucceededEventDetails.ReadOnly =
    zio.aws.sfn.model.ExecutionSucceededEventDetails.wrap(buildAwsValue())
}
object ExecutionSucceededEventDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ExecutionSucceededEventDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ExecutionSucceededEventDetails =
      zio.aws.sfn.model.ExecutionSucceededEventDetails(
        output.map(value => value),
        outputDetails.map(value => value.asEditable)
      )
    def output: Optional[SensitiveData]
    def outputDetails
        : Optional[zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly]
    def getOutput: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("output", output)
    def getOutputDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly
    ] = AwsError.unwrapOptionField("outputDetails", outputDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ExecutionSucceededEventDetails
  ) extends zio.aws.sfn.model.ExecutionSucceededEventDetails.ReadOnly {
    override val output: Optional[SensitiveData] = zio.aws.core.internal
      .optionalFromNullable(impl.output())
      .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val outputDetails: Optional[
      zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputDetails())
      .map(value =>
        zio.aws.sfn.model.HistoryEventExecutionDataDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ExecutionSucceededEventDetails
  ): zio.aws.sfn.model.ExecutionSucceededEventDetails.ReadOnly = new Wrapper(
    impl
  )
}
