package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{Name, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetActivityTaskRequest(
    activityArn: Arn,
    workerName: Optional[Name] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.GetActivityTaskRequest = {
    import GetActivityTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.GetActivityTaskRequest
      .builder()
      .activityArn(Arn.unwrap(activityArn): java.lang.String)
      .optionallyWith(
        workerName.map(value => Name.unwrap(value): java.lang.String)
      )(_.workerName)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.GetActivityTaskRequest.ReadOnly =
    zio.aws.sfn.model.GetActivityTaskRequest.wrap(buildAwsValue())
}
object GetActivityTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.GetActivityTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.GetActivityTaskRequest = zio.aws.sfn.model
      .GetActivityTaskRequest(activityArn, workerName.map(value => value))
    def activityArn: Arn
    def workerName: Optional[Name]
    def getActivityArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(activityArn)
    def getWorkerName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("workerName", workerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.GetActivityTaskRequest
  ) extends zio.aws.sfn.model.GetActivityTaskRequest.ReadOnly {
    override val activityArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.activityArn())
    override val workerName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.workerName())
      .map(value => zio.aws.sfn.model.primitives.Name(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.GetActivityTaskRequest
  ): zio.aws.sfn.model.GetActivityTaskRequest.ReadOnly = new Wrapper(impl)
}
