package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{SensitiveDataJobInput, TaskToken}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetActivityTaskResponse(
    taskToken: Optional[TaskToken] = Optional.Absent,
    input: Optional[SensitiveDataJobInput] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.GetActivityTaskResponse = {
    import GetActivityTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.GetActivityTaskResponse
      .builder()
      .optionallyWith(
        taskToken.map(value => TaskToken.unwrap(value): java.lang.String)
      )(_.taskToken)
      .optionallyWith(
        input.map(value =>
          SensitiveDataJobInput.unwrap(value): java.lang.String
        )
      )(_.input)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.GetActivityTaskResponse.ReadOnly =
    zio.aws.sfn.model.GetActivityTaskResponse.wrap(buildAwsValue())
}
object GetActivityTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.GetActivityTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.GetActivityTaskResponse =
      zio.aws.sfn.model.GetActivityTaskResponse(
        taskToken.map(value => value),
        input.map(value => value)
      )
    def taskToken: Optional[TaskToken]
    def input: Optional[SensitiveDataJobInput]
    def getTaskToken: ZIO[Any, AwsError, TaskToken] =
      AwsError.unwrapOptionField("taskToken", taskToken)
    def getInput: ZIO[Any, AwsError, SensitiveDataJobInput] =
      AwsError.unwrapOptionField("input", input)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.GetActivityTaskResponse
  ) extends zio.aws.sfn.model.GetActivityTaskResponse.ReadOnly {
    override val taskToken: Optional[TaskToken] = zio.aws.core.internal
      .optionalFromNullable(impl.taskToken())
      .map(value => zio.aws.sfn.model.primitives.TaskToken(value))
    override val input: Optional[SensitiveDataJobInput] = zio.aws.core.internal
      .optionalFromNullable(impl.input())
      .map(value => zio.aws.sfn.model.primitives.SensitiveDataJobInput(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.GetActivityTaskResponse
  ): zio.aws.sfn.model.GetActivityTaskResponse.ReadOnly = new Wrapper(impl)
}
