package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.PageToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetExecutionHistoryResponse(
    events: Iterable[zio.aws.sfn.model.HistoryEvent],
    nextToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.GetExecutionHistoryResponse = {
    import GetExecutionHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.GetExecutionHistoryResponse
      .builder()
      .events(events.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.GetExecutionHistoryResponse.ReadOnly =
    zio.aws.sfn.model.GetExecutionHistoryResponse.wrap(buildAwsValue())
}
object GetExecutionHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.GetExecutionHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.GetExecutionHistoryResponse =
      zio.aws.sfn.model.GetExecutionHistoryResponse(
        events.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def events: List[zio.aws.sfn.model.HistoryEvent.ReadOnly]
    def nextToken: Optional[PageToken]
    def getEvents
        : ZIO[Any, Nothing, List[zio.aws.sfn.model.HistoryEvent.ReadOnly]] =
      ZIO.succeed(events)
    def getNextToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.GetExecutionHistoryResponse
  ) extends zio.aws.sfn.model.GetExecutionHistoryResponse.ReadOnly {
    override val events: List[zio.aws.sfn.model.HistoryEvent.ReadOnly] = impl
      .events()
      .asScala
      .map { item =>
        zio.aws.sfn.model.HistoryEvent.wrap(item)
      }
      .toList
    override val nextToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sfn.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.GetExecutionHistoryResponse
  ): zio.aws.sfn.model.GetExecutionHistoryResponse.ReadOnly = new Wrapper(impl)
}
