package zio.aws.sfn.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{EventId, Timestamp}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class HistoryEvent(
    timestamp: Timestamp,
    `type`: zio.aws.sfn.model.HistoryEventType,
    id: EventId,
    previousEventId: Optional[EventId] = Optional.Absent,
    activityFailedEventDetails: Optional[
      zio.aws.sfn.model.ActivityFailedEventDetails
    ] = Optional.Absent,
    activityScheduleFailedEventDetails: Optional[
      zio.aws.sfn.model.ActivityScheduleFailedEventDetails
    ] = Optional.Absent,
    activityScheduledEventDetails: Optional[
      zio.aws.sfn.model.ActivityScheduledEventDetails
    ] = Optional.Absent,
    activityStartedEventDetails: Optional[
      zio.aws.sfn.model.ActivityStartedEventDetails
    ] = Optional.Absent,
    activitySucceededEventDetails: Optional[
      zio.aws.sfn.model.ActivitySucceededEventDetails
    ] = Optional.Absent,
    activityTimedOutEventDetails: Optional[
      zio.aws.sfn.model.ActivityTimedOutEventDetails
    ] = Optional.Absent,
    taskFailedEventDetails: Optional[zio.aws.sfn.model.TaskFailedEventDetails] =
      Optional.Absent,
    taskScheduledEventDetails: Optional[
      zio.aws.sfn.model.TaskScheduledEventDetails
    ] = Optional.Absent,
    taskStartFailedEventDetails: Optional[
      zio.aws.sfn.model.TaskStartFailedEventDetails
    ] = Optional.Absent,
    taskStartedEventDetails: Optional[
      zio.aws.sfn.model.TaskStartedEventDetails
    ] = Optional.Absent,
    taskSubmitFailedEventDetails: Optional[
      zio.aws.sfn.model.TaskSubmitFailedEventDetails
    ] = Optional.Absent,
    taskSubmittedEventDetails: Optional[
      zio.aws.sfn.model.TaskSubmittedEventDetails
    ] = Optional.Absent,
    taskSucceededEventDetails: Optional[
      zio.aws.sfn.model.TaskSucceededEventDetails
    ] = Optional.Absent,
    taskTimedOutEventDetails: Optional[
      zio.aws.sfn.model.TaskTimedOutEventDetails
    ] = Optional.Absent,
    executionFailedEventDetails: Optional[
      zio.aws.sfn.model.ExecutionFailedEventDetails
    ] = Optional.Absent,
    executionStartedEventDetails: Optional[
      zio.aws.sfn.model.ExecutionStartedEventDetails
    ] = Optional.Absent,
    executionSucceededEventDetails: Optional[
      zio.aws.sfn.model.ExecutionSucceededEventDetails
    ] = Optional.Absent,
    executionAbortedEventDetails: Optional[
      zio.aws.sfn.model.ExecutionAbortedEventDetails
    ] = Optional.Absent,
    executionTimedOutEventDetails: Optional[
      zio.aws.sfn.model.ExecutionTimedOutEventDetails
    ] = Optional.Absent,
    executionRedrivenEventDetails: Optional[
      zio.aws.sfn.model.ExecutionRedrivenEventDetails
    ] = Optional.Absent,
    mapStateStartedEventDetails: Optional[
      zio.aws.sfn.model.MapStateStartedEventDetails
    ] = Optional.Absent,
    mapIterationStartedEventDetails: Optional[
      zio.aws.sfn.model.MapIterationEventDetails
    ] = Optional.Absent,
    mapIterationSucceededEventDetails: Optional[
      zio.aws.sfn.model.MapIterationEventDetails
    ] = Optional.Absent,
    mapIterationFailedEventDetails: Optional[
      zio.aws.sfn.model.MapIterationEventDetails
    ] = Optional.Absent,
    mapIterationAbortedEventDetails: Optional[
      zio.aws.sfn.model.MapIterationEventDetails
    ] = Optional.Absent,
    lambdaFunctionFailedEventDetails: Optional[
      zio.aws.sfn.model.LambdaFunctionFailedEventDetails
    ] = Optional.Absent,
    lambdaFunctionScheduleFailedEventDetails: Optional[
      zio.aws.sfn.model.LambdaFunctionScheduleFailedEventDetails
    ] = Optional.Absent,
    lambdaFunctionScheduledEventDetails: Optional[
      zio.aws.sfn.model.LambdaFunctionScheduledEventDetails
    ] = Optional.Absent,
    lambdaFunctionStartFailedEventDetails: Optional[
      zio.aws.sfn.model.LambdaFunctionStartFailedEventDetails
    ] = Optional.Absent,
    lambdaFunctionSucceededEventDetails: Optional[
      zio.aws.sfn.model.LambdaFunctionSucceededEventDetails
    ] = Optional.Absent,
    lambdaFunctionTimedOutEventDetails: Optional[
      zio.aws.sfn.model.LambdaFunctionTimedOutEventDetails
    ] = Optional.Absent,
    stateEnteredEventDetails: Optional[
      zio.aws.sfn.model.StateEnteredEventDetails
    ] = Optional.Absent,
    stateExitedEventDetails: Optional[
      zio.aws.sfn.model.StateExitedEventDetails
    ] = Optional.Absent,
    mapRunStartedEventDetails: Optional[
      zio.aws.sfn.model.MapRunStartedEventDetails
    ] = Optional.Absent,
    mapRunFailedEventDetails: Optional[
      zio.aws.sfn.model.MapRunFailedEventDetails
    ] = Optional.Absent,
    mapRunRedrivenEventDetails: Optional[
      zio.aws.sfn.model.MapRunRedrivenEventDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.HistoryEvent = {
    import HistoryEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.HistoryEvent
      .builder()
      .timestamp(Timestamp.unwrap(timestamp): Instant)
      .`type`(`type`.unwrap)
      .id(EventId.unwrap(id): java.lang.Long)
      .optionallyWith(
        previousEventId.map(value => EventId.unwrap(value): java.lang.Long)
      )(_.previousEventId)
      .optionallyWith(
        activityFailedEventDetails.map(value => value.buildAwsValue())
      )(_.activityFailedEventDetails)
      .optionallyWith(
        activityScheduleFailedEventDetails.map(value => value.buildAwsValue())
      )(_.activityScheduleFailedEventDetails)
      .optionallyWith(
        activityScheduledEventDetails.map(value => value.buildAwsValue())
      )(_.activityScheduledEventDetails)
      .optionallyWith(
        activityStartedEventDetails.map(value => value.buildAwsValue())
      )(_.activityStartedEventDetails)
      .optionallyWith(
        activitySucceededEventDetails.map(value => value.buildAwsValue())
      )(_.activitySucceededEventDetails)
      .optionallyWith(
        activityTimedOutEventDetails.map(value => value.buildAwsValue())
      )(_.activityTimedOutEventDetails)
      .optionallyWith(
        taskFailedEventDetails.map(value => value.buildAwsValue())
      )(_.taskFailedEventDetails)
      .optionallyWith(
        taskScheduledEventDetails.map(value => value.buildAwsValue())
      )(_.taskScheduledEventDetails)
      .optionallyWith(
        taskStartFailedEventDetails.map(value => value.buildAwsValue())
      )(_.taskStartFailedEventDetails)
      .optionallyWith(
        taskStartedEventDetails.map(value => value.buildAwsValue())
      )(_.taskStartedEventDetails)
      .optionallyWith(
        taskSubmitFailedEventDetails.map(value => value.buildAwsValue())
      )(_.taskSubmitFailedEventDetails)
      .optionallyWith(
        taskSubmittedEventDetails.map(value => value.buildAwsValue())
      )(_.taskSubmittedEventDetails)
      .optionallyWith(
        taskSucceededEventDetails.map(value => value.buildAwsValue())
      )(_.taskSucceededEventDetails)
      .optionallyWith(
        taskTimedOutEventDetails.map(value => value.buildAwsValue())
      )(_.taskTimedOutEventDetails)
      .optionallyWith(
        executionFailedEventDetails.map(value => value.buildAwsValue())
      )(_.executionFailedEventDetails)
      .optionallyWith(
        executionStartedEventDetails.map(value => value.buildAwsValue())
      )(_.executionStartedEventDetails)
      .optionallyWith(
        executionSucceededEventDetails.map(value => value.buildAwsValue())
      )(_.executionSucceededEventDetails)
      .optionallyWith(
        executionAbortedEventDetails.map(value => value.buildAwsValue())
      )(_.executionAbortedEventDetails)
      .optionallyWith(
        executionTimedOutEventDetails.map(value => value.buildAwsValue())
      )(_.executionTimedOutEventDetails)
      .optionallyWith(
        executionRedrivenEventDetails.map(value => value.buildAwsValue())
      )(_.executionRedrivenEventDetails)
      .optionallyWith(
        mapStateStartedEventDetails.map(value => value.buildAwsValue())
      )(_.mapStateStartedEventDetails)
      .optionallyWith(
        mapIterationStartedEventDetails.map(value => value.buildAwsValue())
      )(_.mapIterationStartedEventDetails)
      .optionallyWith(
        mapIterationSucceededEventDetails.map(value => value.buildAwsValue())
      )(_.mapIterationSucceededEventDetails)
      .optionallyWith(
        mapIterationFailedEventDetails.map(value => value.buildAwsValue())
      )(_.mapIterationFailedEventDetails)
      .optionallyWith(
        mapIterationAbortedEventDetails.map(value => value.buildAwsValue())
      )(_.mapIterationAbortedEventDetails)
      .optionallyWith(
        lambdaFunctionFailedEventDetails.map(value => value.buildAwsValue())
      )(_.lambdaFunctionFailedEventDetails)
      .optionallyWith(
        lambdaFunctionScheduleFailedEventDetails.map(value =>
          value.buildAwsValue()
        )
      )(_.lambdaFunctionScheduleFailedEventDetails)
      .optionallyWith(
        lambdaFunctionScheduledEventDetails.map(value => value.buildAwsValue())
      )(_.lambdaFunctionScheduledEventDetails)
      .optionallyWith(
        lambdaFunctionStartFailedEventDetails.map(value =>
          value.buildAwsValue()
        )
      )(_.lambdaFunctionStartFailedEventDetails)
      .optionallyWith(
        lambdaFunctionSucceededEventDetails.map(value => value.buildAwsValue())
      )(_.lambdaFunctionSucceededEventDetails)
      .optionallyWith(
        lambdaFunctionTimedOutEventDetails.map(value => value.buildAwsValue())
      )(_.lambdaFunctionTimedOutEventDetails)
      .optionallyWith(
        stateEnteredEventDetails.map(value => value.buildAwsValue())
      )(_.stateEnteredEventDetails)
      .optionallyWith(
        stateExitedEventDetails.map(value => value.buildAwsValue())
      )(_.stateExitedEventDetails)
      .optionallyWith(
        mapRunStartedEventDetails.map(value => value.buildAwsValue())
      )(_.mapRunStartedEventDetails)
      .optionallyWith(
        mapRunFailedEventDetails.map(value => value.buildAwsValue())
      )(_.mapRunFailedEventDetails)
      .optionallyWith(
        mapRunRedrivenEventDetails.map(value => value.buildAwsValue())
      )(_.mapRunRedrivenEventDetails)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.HistoryEvent.ReadOnly =
    zio.aws.sfn.model.HistoryEvent.wrap(buildAwsValue())
}
object HistoryEvent {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sfn.model.HistoryEvent] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.HistoryEvent =
      zio.aws.sfn.model.HistoryEvent(
        timestamp,
        `type`,
        id,
        previousEventId.map(value => value),
        activityFailedEventDetails.map(value => value.asEditable),
        activityScheduleFailedEventDetails.map(value => value.asEditable),
        activityScheduledEventDetails.map(value => value.asEditable),
        activityStartedEventDetails.map(value => value.asEditable),
        activitySucceededEventDetails.map(value => value.asEditable),
        activityTimedOutEventDetails.map(value => value.asEditable),
        taskFailedEventDetails.map(value => value.asEditable),
        taskScheduledEventDetails.map(value => value.asEditable),
        taskStartFailedEventDetails.map(value => value.asEditable),
        taskStartedEventDetails.map(value => value.asEditable),
        taskSubmitFailedEventDetails.map(value => value.asEditable),
        taskSubmittedEventDetails.map(value => value.asEditable),
        taskSucceededEventDetails.map(value => value.asEditable),
        taskTimedOutEventDetails.map(value => value.asEditable),
        executionFailedEventDetails.map(value => value.asEditable),
        executionStartedEventDetails.map(value => value.asEditable),
        executionSucceededEventDetails.map(value => value.asEditable),
        executionAbortedEventDetails.map(value => value.asEditable),
        executionTimedOutEventDetails.map(value => value.asEditable),
        executionRedrivenEventDetails.map(value => value.asEditable),
        mapStateStartedEventDetails.map(value => value.asEditable),
        mapIterationStartedEventDetails.map(value => value.asEditable),
        mapIterationSucceededEventDetails.map(value => value.asEditable),
        mapIterationFailedEventDetails.map(value => value.asEditable),
        mapIterationAbortedEventDetails.map(value => value.asEditable),
        lambdaFunctionFailedEventDetails.map(value => value.asEditable),
        lambdaFunctionScheduleFailedEventDetails.map(value => value.asEditable),
        lambdaFunctionScheduledEventDetails.map(value => value.asEditable),
        lambdaFunctionStartFailedEventDetails.map(value => value.asEditable),
        lambdaFunctionSucceededEventDetails.map(value => value.asEditable),
        lambdaFunctionTimedOutEventDetails.map(value => value.asEditable),
        stateEnteredEventDetails.map(value => value.asEditable),
        stateExitedEventDetails.map(value => value.asEditable),
        mapRunStartedEventDetails.map(value => value.asEditable),
        mapRunFailedEventDetails.map(value => value.asEditable),
        mapRunRedrivenEventDetails.map(value => value.asEditable)
      )
    def timestamp: Timestamp
    def `type`: zio.aws.sfn.model.HistoryEventType
    def id: EventId
    def previousEventId: Optional[EventId]
    def activityFailedEventDetails
        : Optional[zio.aws.sfn.model.ActivityFailedEventDetails.ReadOnly]
    def activityScheduleFailedEventDetails: Optional[
      zio.aws.sfn.model.ActivityScheduleFailedEventDetails.ReadOnly
    ]
    def activityScheduledEventDetails
        : Optional[zio.aws.sfn.model.ActivityScheduledEventDetails.ReadOnly]
    def activityStartedEventDetails
        : Optional[zio.aws.sfn.model.ActivityStartedEventDetails.ReadOnly]
    def activitySucceededEventDetails
        : Optional[zio.aws.sfn.model.ActivitySucceededEventDetails.ReadOnly]
    def activityTimedOutEventDetails
        : Optional[zio.aws.sfn.model.ActivityTimedOutEventDetails.ReadOnly]
    def taskFailedEventDetails
        : Optional[zio.aws.sfn.model.TaskFailedEventDetails.ReadOnly]
    def taskScheduledEventDetails
        : Optional[zio.aws.sfn.model.TaskScheduledEventDetails.ReadOnly]
    def taskStartFailedEventDetails
        : Optional[zio.aws.sfn.model.TaskStartFailedEventDetails.ReadOnly]
    def taskStartedEventDetails
        : Optional[zio.aws.sfn.model.TaskStartedEventDetails.ReadOnly]
    def taskSubmitFailedEventDetails
        : Optional[zio.aws.sfn.model.TaskSubmitFailedEventDetails.ReadOnly]
    def taskSubmittedEventDetails
        : Optional[zio.aws.sfn.model.TaskSubmittedEventDetails.ReadOnly]
    def taskSucceededEventDetails
        : Optional[zio.aws.sfn.model.TaskSucceededEventDetails.ReadOnly]
    def taskTimedOutEventDetails
        : Optional[zio.aws.sfn.model.TaskTimedOutEventDetails.ReadOnly]
    def executionFailedEventDetails
        : Optional[zio.aws.sfn.model.ExecutionFailedEventDetails.ReadOnly]
    def executionStartedEventDetails
        : Optional[zio.aws.sfn.model.ExecutionStartedEventDetails.ReadOnly]
    def executionSucceededEventDetails
        : Optional[zio.aws.sfn.model.ExecutionSucceededEventDetails.ReadOnly]
    def executionAbortedEventDetails
        : Optional[zio.aws.sfn.model.ExecutionAbortedEventDetails.ReadOnly]
    def executionTimedOutEventDetails
        : Optional[zio.aws.sfn.model.ExecutionTimedOutEventDetails.ReadOnly]
    def executionRedrivenEventDetails
        : Optional[zio.aws.sfn.model.ExecutionRedrivenEventDetails.ReadOnly]
    def mapStateStartedEventDetails
        : Optional[zio.aws.sfn.model.MapStateStartedEventDetails.ReadOnly]
    def mapIterationStartedEventDetails
        : Optional[zio.aws.sfn.model.MapIterationEventDetails.ReadOnly]
    def mapIterationSucceededEventDetails
        : Optional[zio.aws.sfn.model.MapIterationEventDetails.ReadOnly]
    def mapIterationFailedEventDetails
        : Optional[zio.aws.sfn.model.MapIterationEventDetails.ReadOnly]
    def mapIterationAbortedEventDetails
        : Optional[zio.aws.sfn.model.MapIterationEventDetails.ReadOnly]
    def lambdaFunctionFailedEventDetails
        : Optional[zio.aws.sfn.model.LambdaFunctionFailedEventDetails.ReadOnly]
    def lambdaFunctionScheduleFailedEventDetails: Optional[
      zio.aws.sfn.model.LambdaFunctionScheduleFailedEventDetails.ReadOnly
    ]
    def lambdaFunctionScheduledEventDetails: Optional[
      zio.aws.sfn.model.LambdaFunctionScheduledEventDetails.ReadOnly
    ]
    def lambdaFunctionStartFailedEventDetails: Optional[
      zio.aws.sfn.model.LambdaFunctionStartFailedEventDetails.ReadOnly
    ]
    def lambdaFunctionSucceededEventDetails: Optional[
      zio.aws.sfn.model.LambdaFunctionSucceededEventDetails.ReadOnly
    ]
    def lambdaFunctionTimedOutEventDetails: Optional[
      zio.aws.sfn.model.LambdaFunctionTimedOutEventDetails.ReadOnly
    ]
    def stateEnteredEventDetails
        : Optional[zio.aws.sfn.model.StateEnteredEventDetails.ReadOnly]
    def stateExitedEventDetails
        : Optional[zio.aws.sfn.model.StateExitedEventDetails.ReadOnly]
    def mapRunStartedEventDetails
        : Optional[zio.aws.sfn.model.MapRunStartedEventDetails.ReadOnly]
    def mapRunFailedEventDetails
        : Optional[zio.aws.sfn.model.MapRunFailedEventDetails.ReadOnly]
    def mapRunRedrivenEventDetails
        : Optional[zio.aws.sfn.model.MapRunRedrivenEventDetails.ReadOnly]
    def getTimestamp: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(timestamp)
    def getType: ZIO[Any, Nothing, zio.aws.sfn.model.HistoryEventType] =
      ZIO.succeed(`type`)
    def getId: ZIO[Any, Nothing, EventId] = ZIO.succeed(id)
    def getPreviousEventId: ZIO[Any, AwsError, EventId] =
      AwsError.unwrapOptionField("previousEventId", previousEventId)
    def getActivityFailedEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.ActivityFailedEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activityFailedEventDetails",
      activityFailedEventDetails
    )
    def getActivityScheduleFailedEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.ActivityScheduleFailedEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activityScheduleFailedEventDetails",
      activityScheduleFailedEventDetails
    )
    def getActivityScheduledEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.ActivityScheduledEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activityScheduledEventDetails",
      activityScheduledEventDetails
    )
    def getActivityStartedEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.ActivityStartedEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activityStartedEventDetails",
      activityStartedEventDetails
    )
    def getActivitySucceededEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.ActivitySucceededEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activitySucceededEventDetails",
      activitySucceededEventDetails
    )
    def getActivityTimedOutEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.ActivityTimedOutEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activityTimedOutEventDetails",
      activityTimedOutEventDetails
    )
    def getTaskFailedEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.TaskFailedEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "taskFailedEventDetails",
      taskFailedEventDetails
    )
    def getTaskScheduledEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.TaskScheduledEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "taskScheduledEventDetails",
      taskScheduledEventDetails
    )
    def getTaskStartFailedEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.TaskStartFailedEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "taskStartFailedEventDetails",
      taskStartFailedEventDetails
    )
    def getTaskStartedEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.TaskStartedEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "taskStartedEventDetails",
      taskStartedEventDetails
    )
    def getTaskSubmitFailedEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.TaskSubmitFailedEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "taskSubmitFailedEventDetails",
      taskSubmitFailedEventDetails
    )
    def getTaskSubmittedEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.TaskSubmittedEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "taskSubmittedEventDetails",
      taskSubmittedEventDetails
    )
    def getTaskSucceededEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.TaskSucceededEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "taskSucceededEventDetails",
      taskSucceededEventDetails
    )
    def getTaskTimedOutEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.TaskTimedOutEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "taskTimedOutEventDetails",
      taskTimedOutEventDetails
    )
    def getExecutionFailedEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.ExecutionFailedEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "executionFailedEventDetails",
      executionFailedEventDetails
    )
    def getExecutionStartedEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.ExecutionStartedEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "executionStartedEventDetails",
      executionStartedEventDetails
    )
    def getExecutionSucceededEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.ExecutionSucceededEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "executionSucceededEventDetails",
      executionSucceededEventDetails
    )
    def getExecutionAbortedEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.ExecutionAbortedEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "executionAbortedEventDetails",
      executionAbortedEventDetails
    )
    def getExecutionTimedOutEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.ExecutionTimedOutEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "executionTimedOutEventDetails",
      executionTimedOutEventDetails
    )
    def getExecutionRedrivenEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.ExecutionRedrivenEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "executionRedrivenEventDetails",
      executionRedrivenEventDetails
    )
    def getMapStateStartedEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.MapStateStartedEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mapStateStartedEventDetails",
      mapStateStartedEventDetails
    )
    def getMapIterationStartedEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.MapIterationEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mapIterationStartedEventDetails",
      mapIterationStartedEventDetails
    )
    def getMapIterationSucceededEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.MapIterationEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mapIterationSucceededEventDetails",
      mapIterationSucceededEventDetails
    )
    def getMapIterationFailedEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.MapIterationEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mapIterationFailedEventDetails",
      mapIterationFailedEventDetails
    )
    def getMapIterationAbortedEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.MapIterationEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mapIterationAbortedEventDetails",
      mapIterationAbortedEventDetails
    )
    def getLambdaFunctionFailedEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.LambdaFunctionFailedEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaFunctionFailedEventDetails",
      lambdaFunctionFailedEventDetails
    )
    def getLambdaFunctionScheduleFailedEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.LambdaFunctionScheduleFailedEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaFunctionScheduleFailedEventDetails",
      lambdaFunctionScheduleFailedEventDetails
    )
    def getLambdaFunctionScheduledEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.LambdaFunctionScheduledEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaFunctionScheduledEventDetails",
      lambdaFunctionScheduledEventDetails
    )
    def getLambdaFunctionStartFailedEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.LambdaFunctionStartFailedEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaFunctionStartFailedEventDetails",
      lambdaFunctionStartFailedEventDetails
    )
    def getLambdaFunctionSucceededEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.LambdaFunctionSucceededEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaFunctionSucceededEventDetails",
      lambdaFunctionSucceededEventDetails
    )
    def getLambdaFunctionTimedOutEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.LambdaFunctionTimedOutEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaFunctionTimedOutEventDetails",
      lambdaFunctionTimedOutEventDetails
    )
    def getStateEnteredEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.StateEnteredEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "stateEnteredEventDetails",
      stateEnteredEventDetails
    )
    def getStateExitedEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.StateExitedEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "stateExitedEventDetails",
      stateExitedEventDetails
    )
    def getMapRunStartedEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.MapRunStartedEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mapRunStartedEventDetails",
      mapRunStartedEventDetails
    )
    def getMapRunFailedEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.MapRunFailedEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mapRunFailedEventDetails",
      mapRunFailedEventDetails
    )
    def getMapRunRedrivenEventDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.MapRunRedrivenEventDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mapRunRedrivenEventDetails",
      mapRunRedrivenEventDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.HistoryEvent
  ) extends zio.aws.sfn.model.HistoryEvent.ReadOnly {
    override val timestamp: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.timestamp())
    override val `type`: zio.aws.sfn.model.HistoryEventType =
      zio.aws.sfn.model.HistoryEventType.wrap(impl.`type`())
    override val id: EventId = zio.aws.sfn.model.primitives.EventId(impl.id())
    override val previousEventId: Optional[EventId] = zio.aws.core.internal
      .optionalFromNullable(impl.previousEventId())
      .map(value => zio.aws.sfn.model.primitives.EventId(value))
    override val activityFailedEventDetails
        : Optional[zio.aws.sfn.model.ActivityFailedEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activityFailedEventDetails())
        .map(value => zio.aws.sfn.model.ActivityFailedEventDetails.wrap(value))
    override val activityScheduleFailedEventDetails: Optional[
      zio.aws.sfn.model.ActivityScheduleFailedEventDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.activityScheduleFailedEventDetails())
      .map(value =>
        zio.aws.sfn.model.ActivityScheduleFailedEventDetails.wrap(value)
      )
    override val activityScheduledEventDetails
        : Optional[zio.aws.sfn.model.ActivityScheduledEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activityScheduledEventDetails())
        .map(value =>
          zio.aws.sfn.model.ActivityScheduledEventDetails.wrap(value)
        )
    override val activityStartedEventDetails
        : Optional[zio.aws.sfn.model.ActivityStartedEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activityStartedEventDetails())
        .map(value => zio.aws.sfn.model.ActivityStartedEventDetails.wrap(value))
    override val activitySucceededEventDetails
        : Optional[zio.aws.sfn.model.ActivitySucceededEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activitySucceededEventDetails())
        .map(value =>
          zio.aws.sfn.model.ActivitySucceededEventDetails.wrap(value)
        )
    override val activityTimedOutEventDetails
        : Optional[zio.aws.sfn.model.ActivityTimedOutEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activityTimedOutEventDetails())
        .map(value =>
          zio.aws.sfn.model.ActivityTimedOutEventDetails.wrap(value)
        )
    override val taskFailedEventDetails
        : Optional[zio.aws.sfn.model.TaskFailedEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskFailedEventDetails())
        .map(value => zio.aws.sfn.model.TaskFailedEventDetails.wrap(value))
    override val taskScheduledEventDetails
        : Optional[zio.aws.sfn.model.TaskScheduledEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskScheduledEventDetails())
        .map(value => zio.aws.sfn.model.TaskScheduledEventDetails.wrap(value))
    override val taskStartFailedEventDetails
        : Optional[zio.aws.sfn.model.TaskStartFailedEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskStartFailedEventDetails())
        .map(value => zio.aws.sfn.model.TaskStartFailedEventDetails.wrap(value))
    override val taskStartedEventDetails
        : Optional[zio.aws.sfn.model.TaskStartedEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskStartedEventDetails())
        .map(value => zio.aws.sfn.model.TaskStartedEventDetails.wrap(value))
    override val taskSubmitFailedEventDetails
        : Optional[zio.aws.sfn.model.TaskSubmitFailedEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskSubmitFailedEventDetails())
        .map(value =>
          zio.aws.sfn.model.TaskSubmitFailedEventDetails.wrap(value)
        )
    override val taskSubmittedEventDetails
        : Optional[zio.aws.sfn.model.TaskSubmittedEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskSubmittedEventDetails())
        .map(value => zio.aws.sfn.model.TaskSubmittedEventDetails.wrap(value))
    override val taskSucceededEventDetails
        : Optional[zio.aws.sfn.model.TaskSucceededEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskSucceededEventDetails())
        .map(value => zio.aws.sfn.model.TaskSucceededEventDetails.wrap(value))
    override val taskTimedOutEventDetails
        : Optional[zio.aws.sfn.model.TaskTimedOutEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskTimedOutEventDetails())
        .map(value => zio.aws.sfn.model.TaskTimedOutEventDetails.wrap(value))
    override val executionFailedEventDetails
        : Optional[zio.aws.sfn.model.ExecutionFailedEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionFailedEventDetails())
        .map(value => zio.aws.sfn.model.ExecutionFailedEventDetails.wrap(value))
    override val executionStartedEventDetails
        : Optional[zio.aws.sfn.model.ExecutionStartedEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionStartedEventDetails())
        .map(value =>
          zio.aws.sfn.model.ExecutionStartedEventDetails.wrap(value)
        )
    override val executionSucceededEventDetails
        : Optional[zio.aws.sfn.model.ExecutionSucceededEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionSucceededEventDetails())
        .map(value =>
          zio.aws.sfn.model.ExecutionSucceededEventDetails.wrap(value)
        )
    override val executionAbortedEventDetails
        : Optional[zio.aws.sfn.model.ExecutionAbortedEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionAbortedEventDetails())
        .map(value =>
          zio.aws.sfn.model.ExecutionAbortedEventDetails.wrap(value)
        )
    override val executionTimedOutEventDetails
        : Optional[zio.aws.sfn.model.ExecutionTimedOutEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionTimedOutEventDetails())
        .map(value =>
          zio.aws.sfn.model.ExecutionTimedOutEventDetails.wrap(value)
        )
    override val executionRedrivenEventDetails
        : Optional[zio.aws.sfn.model.ExecutionRedrivenEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionRedrivenEventDetails())
        .map(value =>
          zio.aws.sfn.model.ExecutionRedrivenEventDetails.wrap(value)
        )
    override val mapStateStartedEventDetails
        : Optional[zio.aws.sfn.model.MapStateStartedEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mapStateStartedEventDetails())
        .map(value => zio.aws.sfn.model.MapStateStartedEventDetails.wrap(value))
    override val mapIterationStartedEventDetails
        : Optional[zio.aws.sfn.model.MapIterationEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mapIterationStartedEventDetails())
        .map(value => zio.aws.sfn.model.MapIterationEventDetails.wrap(value))
    override val mapIterationSucceededEventDetails
        : Optional[zio.aws.sfn.model.MapIterationEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mapIterationSucceededEventDetails())
        .map(value => zio.aws.sfn.model.MapIterationEventDetails.wrap(value))
    override val mapIterationFailedEventDetails
        : Optional[zio.aws.sfn.model.MapIterationEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mapIterationFailedEventDetails())
        .map(value => zio.aws.sfn.model.MapIterationEventDetails.wrap(value))
    override val mapIterationAbortedEventDetails
        : Optional[zio.aws.sfn.model.MapIterationEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mapIterationAbortedEventDetails())
        .map(value => zio.aws.sfn.model.MapIterationEventDetails.wrap(value))
    override val lambdaFunctionFailedEventDetails: Optional[
      zio.aws.sfn.model.LambdaFunctionFailedEventDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaFunctionFailedEventDetails())
      .map(value =>
        zio.aws.sfn.model.LambdaFunctionFailedEventDetails.wrap(value)
      )
    override val lambdaFunctionScheduleFailedEventDetails: Optional[
      zio.aws.sfn.model.LambdaFunctionScheduleFailedEventDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaFunctionScheduleFailedEventDetails())
      .map(value =>
        zio.aws.sfn.model.LambdaFunctionScheduleFailedEventDetails.wrap(value)
      )
    override val lambdaFunctionScheduledEventDetails: Optional[
      zio.aws.sfn.model.LambdaFunctionScheduledEventDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaFunctionScheduledEventDetails())
      .map(value =>
        zio.aws.sfn.model.LambdaFunctionScheduledEventDetails.wrap(value)
      )
    override val lambdaFunctionStartFailedEventDetails: Optional[
      zio.aws.sfn.model.LambdaFunctionStartFailedEventDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaFunctionStartFailedEventDetails())
      .map(value =>
        zio.aws.sfn.model.LambdaFunctionStartFailedEventDetails.wrap(value)
      )
    override val lambdaFunctionSucceededEventDetails: Optional[
      zio.aws.sfn.model.LambdaFunctionSucceededEventDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaFunctionSucceededEventDetails())
      .map(value =>
        zio.aws.sfn.model.LambdaFunctionSucceededEventDetails.wrap(value)
      )
    override val lambdaFunctionTimedOutEventDetails: Optional[
      zio.aws.sfn.model.LambdaFunctionTimedOutEventDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaFunctionTimedOutEventDetails())
      .map(value =>
        zio.aws.sfn.model.LambdaFunctionTimedOutEventDetails.wrap(value)
      )
    override val stateEnteredEventDetails
        : Optional[zio.aws.sfn.model.StateEnteredEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateEnteredEventDetails())
        .map(value => zio.aws.sfn.model.StateEnteredEventDetails.wrap(value))
    override val stateExitedEventDetails
        : Optional[zio.aws.sfn.model.StateExitedEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateExitedEventDetails())
        .map(value => zio.aws.sfn.model.StateExitedEventDetails.wrap(value))
    override val mapRunStartedEventDetails
        : Optional[zio.aws.sfn.model.MapRunStartedEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mapRunStartedEventDetails())
        .map(value => zio.aws.sfn.model.MapRunStartedEventDetails.wrap(value))
    override val mapRunFailedEventDetails
        : Optional[zio.aws.sfn.model.MapRunFailedEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mapRunFailedEventDetails())
        .map(value => zio.aws.sfn.model.MapRunFailedEventDetails.wrap(value))
    override val mapRunRedrivenEventDetails
        : Optional[zio.aws.sfn.model.MapRunRedrivenEventDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mapRunRedrivenEventDetails())
        .map(value => zio.aws.sfn.model.MapRunRedrivenEventDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.HistoryEvent
  ): zio.aws.sfn.model.HistoryEvent.ReadOnly = new Wrapper(impl)
}
