package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.Truncated
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HistoryEventExecutionDataDetails(
    truncated: Optional[Truncated] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.HistoryEventExecutionDataDetails = {
    import HistoryEventExecutionDataDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.HistoryEventExecutionDataDetails
      .builder()
      .optionallyWith(
        truncated.map(value => Truncated.unwrap(value): java.lang.Boolean)
      )(_.truncated)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly =
    zio.aws.sfn.model.HistoryEventExecutionDataDetails.wrap(buildAwsValue())
}
object HistoryEventExecutionDataDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.HistoryEventExecutionDataDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.HistoryEventExecutionDataDetails =
      zio.aws.sfn.model
        .HistoryEventExecutionDataDetails(truncated.map(value => value))
    def truncated: Optional[Truncated]
    def getTruncated: ZIO[Any, AwsError, Truncated] =
      AwsError.unwrapOptionField("truncated", truncated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.HistoryEventExecutionDataDetails
  ) extends zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly {
    override val truncated: Optional[Truncated] = zio.aws.core.internal
      .optionalFromNullable(impl.truncated())
      .map(value => zio.aws.sfn.model.primitives.Truncated(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.HistoryEventExecutionDataDetails
  ): zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly = new Wrapper(
    impl
  )
}
