package zio.aws.sfn.model
import scala.jdk.CollectionConverters._
sealed trait HistoryEventType {
  def unwrap: software.amazon.awssdk.services.sfn.model.HistoryEventType
}
object HistoryEventType {
  def wrap(
      value: software.amazon.awssdk.services.sfn.model.HistoryEventType
  ): zio.aws.sfn.model.HistoryEventType = value match {
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.ACTIVITY_FAILED =>
      val r = ActivityFailed
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.ACTIVITY_SCHEDULED =>
      val r = ActivityScheduled
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.ACTIVITY_SCHEDULE_FAILED =>
      val r = ActivityScheduleFailed
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.ACTIVITY_STARTED =>
      val r = ActivityStarted
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.ACTIVITY_SUCCEEDED =>
      val r = ActivitySucceeded
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.ACTIVITY_TIMED_OUT =>
      val r = ActivityTimedOut
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.CHOICE_STATE_ENTERED =>
      val r = ChoiceStateEntered
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.CHOICE_STATE_EXITED =>
      val r = ChoiceStateExited
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.EXECUTION_ABORTED =>
      val r = ExecutionAborted
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.EXECUTION_FAILED =>
      val r = ExecutionFailed
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.EXECUTION_STARTED =>
      val r = ExecutionStarted
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.EXECUTION_SUCCEEDED =>
      val r = ExecutionSucceeded
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.EXECUTION_TIMED_OUT =>
      val r = ExecutionTimedOut
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.FAIL_STATE_ENTERED =>
      val r = FailStateEntered
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.LAMBDA_FUNCTION_FAILED =>
      val r = LambdaFunctionFailed
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.LAMBDA_FUNCTION_SCHEDULED =>
      val r = LambdaFunctionScheduled
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.LAMBDA_FUNCTION_SCHEDULE_FAILED =>
      val r = LambdaFunctionScheduleFailed
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.LAMBDA_FUNCTION_STARTED =>
      val r = LambdaFunctionStarted
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.LAMBDA_FUNCTION_START_FAILED =>
      val r = LambdaFunctionStartFailed
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.LAMBDA_FUNCTION_SUCCEEDED =>
      val r = LambdaFunctionSucceeded
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.LAMBDA_FUNCTION_TIMED_OUT =>
      val r = LambdaFunctionTimedOut
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_ITERATION_ABORTED =>
      val r = MapIterationAborted
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_ITERATION_FAILED =>
      val r = MapIterationFailed
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_ITERATION_STARTED =>
      val r = MapIterationStarted
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_ITERATION_SUCCEEDED =>
      val r = MapIterationSucceeded
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_STATE_ABORTED =>
      val r = MapStateAborted
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_STATE_ENTERED =>
      val r = MapStateEntered
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_STATE_EXITED =>
      val r = MapStateExited
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_STATE_FAILED =>
      val r = MapStateFailed
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_STATE_STARTED =>
      val r = MapStateStarted
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_STATE_SUCCEEDED =>
      val r = MapStateSucceeded
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.PARALLEL_STATE_ABORTED =>
      val r = ParallelStateAborted
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.PARALLEL_STATE_ENTERED =>
      val r = ParallelStateEntered
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.PARALLEL_STATE_EXITED =>
      val r = ParallelStateExited
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.PARALLEL_STATE_FAILED =>
      val r = ParallelStateFailed
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.PARALLEL_STATE_STARTED =>
      val r = ParallelStateStarted
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.PARALLEL_STATE_SUCCEEDED =>
      val r = ParallelStateSucceeded
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.PASS_STATE_ENTERED =>
      val r = PassStateEntered
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.PASS_STATE_EXITED =>
      val r = PassStateExited
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.SUCCEED_STATE_ENTERED =>
      val r = SucceedStateEntered
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.SUCCEED_STATE_EXITED =>
      val r = SucceedStateExited
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.TASK_FAILED =>
      val r = TaskFailed
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.TASK_SCHEDULED =>
      val r = TaskScheduled
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.TASK_STARTED =>
      val r = TaskStarted
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.TASK_START_FAILED =>
      val r = TaskStartFailed
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.TASK_STATE_ABORTED =>
      val r = TaskStateAborted
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.TASK_STATE_ENTERED =>
      val r = TaskStateEntered
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.TASK_STATE_EXITED =>
      val r = TaskStateExited
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.TASK_SUBMIT_FAILED =>
      val r = TaskSubmitFailed
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.TASK_SUBMITTED =>
      val r = TaskSubmitted
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.TASK_SUCCEEDED =>
      val r = TaskSucceeded
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.TASK_TIMED_OUT =>
      val r = TaskTimedOut
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.WAIT_STATE_ABORTED =>
      val r = WaitStateAborted
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.WAIT_STATE_ENTERED =>
      val r = WaitStateEntered
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.WAIT_STATE_EXITED =>
      val r = WaitStateExited
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_RUN_ABORTED =>
      val r = MapRunAborted
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_RUN_FAILED =>
      val r = MapRunFailed
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_RUN_STARTED =>
      val r = MapRunStarted
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_RUN_SUCCEEDED =>
      val r = MapRunSucceeded
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.EXECUTION_REDRIVEN =>
      val r = ExecutionRedriven
      r
    case software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_RUN_REDRIVEN =>
      val r = MapRunRedriven
      r
  }
  case object unknownToSdkVersion extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.UNKNOWN_TO_SDK_VERSION
  }
  case object ActivityFailed extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.ACTIVITY_FAILED
  }
  case object ActivityScheduled extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.ACTIVITY_SCHEDULED
  }
  case object ActivityScheduleFailed
      extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.ACTIVITY_SCHEDULE_FAILED
  }
  case object ActivityStarted extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.ACTIVITY_STARTED
  }
  case object ActivitySucceeded extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.ACTIVITY_SUCCEEDED
  }
  case object ActivityTimedOut extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.ACTIVITY_TIMED_OUT
  }
  case object ChoiceStateEntered extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.CHOICE_STATE_ENTERED
  }
  case object ChoiceStateExited extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.CHOICE_STATE_EXITED
  }
  case object ExecutionAborted extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.EXECUTION_ABORTED
  }
  case object ExecutionFailed extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.EXECUTION_FAILED
  }
  case object ExecutionStarted extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.EXECUTION_STARTED
  }
  case object ExecutionSucceeded extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.EXECUTION_SUCCEEDED
  }
  case object ExecutionTimedOut extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.EXECUTION_TIMED_OUT
  }
  case object FailStateEntered extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.FAIL_STATE_ENTERED
  }
  case object LambdaFunctionFailed extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.LAMBDA_FUNCTION_FAILED
  }
  case object LambdaFunctionScheduled
      extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.LAMBDA_FUNCTION_SCHEDULED
  }
  case object LambdaFunctionScheduleFailed
      extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.LAMBDA_FUNCTION_SCHEDULE_FAILED
  }
  case object LambdaFunctionStarted extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.LAMBDA_FUNCTION_STARTED
  }
  case object LambdaFunctionStartFailed
      extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.LAMBDA_FUNCTION_START_FAILED
  }
  case object LambdaFunctionSucceeded
      extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.LAMBDA_FUNCTION_SUCCEEDED
  }
  case object LambdaFunctionTimedOut
      extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.LAMBDA_FUNCTION_TIMED_OUT
  }
  case object MapIterationAborted extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_ITERATION_ABORTED
  }
  case object MapIterationFailed extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_ITERATION_FAILED
  }
  case object MapIterationStarted extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_ITERATION_STARTED
  }
  case object MapIterationSucceeded extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_ITERATION_SUCCEEDED
  }
  case object MapStateAborted extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_STATE_ABORTED
  }
  case object MapStateEntered extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_STATE_ENTERED
  }
  case object MapStateExited extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_STATE_EXITED
  }
  case object MapStateFailed extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_STATE_FAILED
  }
  case object MapStateStarted extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_STATE_STARTED
  }
  case object MapStateSucceeded extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_STATE_SUCCEEDED
  }
  case object ParallelStateAborted extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.PARALLEL_STATE_ABORTED
  }
  case object ParallelStateEntered extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.PARALLEL_STATE_ENTERED
  }
  case object ParallelStateExited extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.PARALLEL_STATE_EXITED
  }
  case object ParallelStateFailed extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.PARALLEL_STATE_FAILED
  }
  case object ParallelStateStarted extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.PARALLEL_STATE_STARTED
  }
  case object ParallelStateSucceeded
      extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.PARALLEL_STATE_SUCCEEDED
  }
  case object PassStateEntered extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.PASS_STATE_ENTERED
  }
  case object PassStateExited extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.PASS_STATE_EXITED
  }
  case object SucceedStateEntered extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.SUCCEED_STATE_ENTERED
  }
  case object SucceedStateExited extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.SUCCEED_STATE_EXITED
  }
  case object TaskFailed extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.TASK_FAILED
  }
  case object TaskScheduled extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.TASK_SCHEDULED
  }
  case object TaskStarted extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.TASK_STARTED
  }
  case object TaskStartFailed extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.TASK_START_FAILED
  }
  case object TaskStateAborted extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.TASK_STATE_ABORTED
  }
  case object TaskStateEntered extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.TASK_STATE_ENTERED
  }
  case object TaskStateExited extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.TASK_STATE_EXITED
  }
  case object TaskSubmitFailed extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.TASK_SUBMIT_FAILED
  }
  case object TaskSubmitted extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.TASK_SUBMITTED
  }
  case object TaskSucceeded extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.TASK_SUCCEEDED
  }
  case object TaskTimedOut extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.TASK_TIMED_OUT
  }
  case object WaitStateAborted extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.WAIT_STATE_ABORTED
  }
  case object WaitStateEntered extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.WAIT_STATE_ENTERED
  }
  case object WaitStateExited extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.WAIT_STATE_EXITED
  }
  case object MapRunAborted extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_RUN_ABORTED
  }
  case object MapRunFailed extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_RUN_FAILED
  }
  case object MapRunStarted extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_RUN_STARTED
  }
  case object MapRunSucceeded extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_RUN_SUCCEEDED
  }
  case object ExecutionRedriven extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.EXECUTION_REDRIVEN
  }
  case object MapRunRedriven extends zio.aws.sfn.model.HistoryEventType {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.HistoryEventType =
      software.amazon.awssdk.services.sfn.model.HistoryEventType.MAP_RUN_REDRIVEN
  }
}
