package zio.aws.sfn.model
import scala.jdk.CollectionConverters._
sealed trait IncludedData {
  def unwrap: software.amazon.awssdk.services.sfn.model.IncludedData
}
object IncludedData {
  def wrap(
      value: software.amazon.awssdk.services.sfn.model.IncludedData
  ): zio.aws.sfn.model.IncludedData = value match {
    case software.amazon.awssdk.services.sfn.model.IncludedData.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sfn.model.IncludedData.ALL_DATA =>
      val r = ALL_DATA
      r
    case software.amazon.awssdk.services.sfn.model.IncludedData.METADATA_ONLY =>
      val r = METADATA_ONLY
      r
  }
  case object unknownToSdkVersion extends zio.aws.sfn.model.IncludedData {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.IncludedData =
      software.amazon.awssdk.services.sfn.model.IncludedData.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL_DATA extends zio.aws.sfn.model.IncludedData {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.IncludedData =
      software.amazon.awssdk.services.sfn.model.IncludedData.ALL_DATA
  }
  case object METADATA_ONLY extends zio.aws.sfn.model.IncludedData {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.IncludedData =
      software.amazon.awssdk.services.sfn.model.IncludedData.METADATA_ONLY
  }
}
