package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.SensitiveData
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InspectionData(
    input: Optional[SensitiveData] = Optional.Absent,
    afterInputPath: Optional[SensitiveData] = Optional.Absent,
    afterParameters: Optional[SensitiveData] = Optional.Absent,
    result: Optional[SensitiveData] = Optional.Absent,
    afterResultSelector: Optional[SensitiveData] = Optional.Absent,
    afterResultPath: Optional[SensitiveData] = Optional.Absent,
    request: Optional[zio.aws.sfn.model.InspectionDataRequest] =
      Optional.Absent,
    response: Optional[zio.aws.sfn.model.InspectionDataResponse] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.InspectionData = {
    import InspectionData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.InspectionData
      .builder()
      .optionallyWith(
        input.map(value => SensitiveData.unwrap(value): java.lang.String)
      )(_.input)
      .optionallyWith(
        afterInputPath.map(value =>
          SensitiveData.unwrap(value): java.lang.String
        )
      )(_.afterInputPath)
      .optionallyWith(
        afterParameters.map(value =>
          SensitiveData.unwrap(value): java.lang.String
        )
      )(_.afterParameters)
      .optionallyWith(
        result.map(value => SensitiveData.unwrap(value): java.lang.String)
      )(_.result)
      .optionallyWith(
        afterResultSelector.map(value =>
          SensitiveData.unwrap(value): java.lang.String
        )
      )(_.afterResultSelector)
      .optionallyWith(
        afterResultPath.map(value =>
          SensitiveData.unwrap(value): java.lang.String
        )
      )(_.afterResultPath)
      .optionallyWith(request.map(value => value.buildAwsValue()))(_.request)
      .optionallyWith(response.map(value => value.buildAwsValue()))(_.response)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.InspectionData.ReadOnly =
    zio.aws.sfn.model.InspectionData.wrap(buildAwsValue())
}
object InspectionData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.InspectionData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.InspectionData =
      zio.aws.sfn.model.InspectionData(
        input.map(value => value),
        afterInputPath.map(value => value),
        afterParameters.map(value => value),
        result.map(value => value),
        afterResultSelector.map(value => value),
        afterResultPath.map(value => value),
        request.map(value => value.asEditable),
        response.map(value => value.asEditable)
      )
    def input: Optional[SensitiveData]
    def afterInputPath: Optional[SensitiveData]
    def afterParameters: Optional[SensitiveData]
    def result: Optional[SensitiveData]
    def afterResultSelector: Optional[SensitiveData]
    def afterResultPath: Optional[SensitiveData]
    def request: Optional[zio.aws.sfn.model.InspectionDataRequest.ReadOnly]
    def response: Optional[zio.aws.sfn.model.InspectionDataResponse.ReadOnly]
    def getInput: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("input", input)
    def getAfterInputPath: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("afterInputPath", afterInputPath)
    def getAfterParameters: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("afterParameters", afterParameters)
    def getResult: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("result", result)
    def getAfterResultSelector: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("afterResultSelector", afterResultSelector)
    def getAfterResultPath: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("afterResultPath", afterResultPath)
    def getRequest
        : ZIO[Any, AwsError, zio.aws.sfn.model.InspectionDataRequest.ReadOnly] =
      AwsError.unwrapOptionField("request", request)
    def getResponse: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.InspectionDataResponse.ReadOnly
    ] = AwsError.unwrapOptionField("response", response)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.InspectionData
  ) extends zio.aws.sfn.model.InspectionData.ReadOnly {
    override val input: Optional[SensitiveData] = zio.aws.core.internal
      .optionalFromNullable(impl.input())
      .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val afterInputPath: Optional[SensitiveData] = zio.aws.core.internal
      .optionalFromNullable(impl.afterInputPath())
      .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val afterParameters: Optional[SensitiveData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.afterParameters())
        .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val result: Optional[SensitiveData] = zio.aws.core.internal
      .optionalFromNullable(impl.result())
      .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val afterResultSelector: Optional[SensitiveData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.afterResultSelector())
        .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val afterResultPath: Optional[SensitiveData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.afterResultPath())
        .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val request
        : Optional[zio.aws.sfn.model.InspectionDataRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.request())
        .map(value => zio.aws.sfn.model.InspectionDataRequest.wrap(value))
    override val response
        : Optional[zio.aws.sfn.model.InspectionDataResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.response())
        .map(value => zio.aws.sfn.model.InspectionDataResponse.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.InspectionData
  ): zio.aws.sfn.model.InspectionData.ReadOnly = new Wrapper(impl)
}
