package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{
  HTTPHeaders,
  HTTPMethod,
  HTTPBody,
  URL,
  HTTPProtocol
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InspectionDataRequest(
    protocol: Optional[HTTPProtocol] = Optional.Absent,
    method: Optional[HTTPMethod] = Optional.Absent,
    url: Optional[URL] = Optional.Absent,
    headers: Optional[HTTPHeaders] = Optional.Absent,
    body: Optional[HTTPBody] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.InspectionDataRequest = {
    import InspectionDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.InspectionDataRequest
      .builder()
      .optionallyWith(
        protocol.map(value => HTTPProtocol.unwrap(value): java.lang.String)
      )(_.protocol)
      .optionallyWith(
        method.map(value => HTTPMethod.unwrap(value): java.lang.String)
      )(_.method)
      .optionallyWith(url.map(value => URL.unwrap(value): java.lang.String))(
        _.url
      )
      .optionallyWith(
        headers.map(value => HTTPHeaders.unwrap(value): java.lang.String)
      )(_.headers)
      .optionallyWith(
        body.map(value => HTTPBody.unwrap(value): java.lang.String)
      )(_.body)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.InspectionDataRequest.ReadOnly =
    zio.aws.sfn.model.InspectionDataRequest.wrap(buildAwsValue())
}
object InspectionDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.InspectionDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.InspectionDataRequest =
      zio.aws.sfn.model.InspectionDataRequest(
        protocol.map(value => value),
        method.map(value => value),
        url.map(value => value),
        headers.map(value => value),
        body.map(value => value)
      )
    def protocol: Optional[HTTPProtocol]
    def method: Optional[HTTPMethod]
    def url: Optional[URL]
    def headers: Optional[HTTPHeaders]
    def body: Optional[HTTPBody]
    def getProtocol: ZIO[Any, AwsError, HTTPProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getMethod: ZIO[Any, AwsError, HTTPMethod] =
      AwsError.unwrapOptionField("method", method)
    def getUrl: ZIO[Any, AwsError, URL] = AwsError.unwrapOptionField("url", url)
    def getHeaders: ZIO[Any, AwsError, HTTPHeaders] =
      AwsError.unwrapOptionField("headers", headers)
    def getBody: ZIO[Any, AwsError, HTTPBody] =
      AwsError.unwrapOptionField("body", body)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.InspectionDataRequest
  ) extends zio.aws.sfn.model.InspectionDataRequest.ReadOnly {
    override val protocol: Optional[HTTPProtocol] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => zio.aws.sfn.model.primitives.HTTPProtocol(value))
    override val method: Optional[HTTPMethod] = zio.aws.core.internal
      .optionalFromNullable(impl.method())
      .map(value => zio.aws.sfn.model.primitives.HTTPMethod(value))
    override val url: Optional[URL] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.sfn.model.primitives.URL(value))
    override val headers: Optional[HTTPHeaders] = zio.aws.core.internal
      .optionalFromNullable(impl.headers())
      .map(value => zio.aws.sfn.model.primitives.HTTPHeaders(value))
    override val body: Optional[HTTPBody] = zio.aws.core.internal
      .optionalFromNullable(impl.body())
      .map(value => zio.aws.sfn.model.primitives.HTTPBody(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.InspectionDataRequest
  ): zio.aws.sfn.model.InspectionDataRequest.ReadOnly = new Wrapper(impl)
}
