package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{
  HTTPHeaders,
  HTTPStatusCode,
  HTTPBody,
  HTTPProtocol,
  HTTPStatusMessage
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InspectionDataResponse(
    protocol: Optional[HTTPProtocol] = Optional.Absent,
    statusCode: Optional[HTTPStatusCode] = Optional.Absent,
    statusMessage: Optional[HTTPStatusMessage] = Optional.Absent,
    headers: Optional[HTTPHeaders] = Optional.Absent,
    body: Optional[HTTPBody] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.InspectionDataResponse = {
    import InspectionDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.InspectionDataResponse
      .builder()
      .optionallyWith(
        protocol.map(value => HTTPProtocol.unwrap(value): java.lang.String)
      )(_.protocol)
      .optionallyWith(
        statusCode.map(value => HTTPStatusCode.unwrap(value): java.lang.String)
      )(_.statusCode)
      .optionallyWith(
        statusMessage.map(value =>
          HTTPStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        headers.map(value => HTTPHeaders.unwrap(value): java.lang.String)
      )(_.headers)
      .optionallyWith(
        body.map(value => HTTPBody.unwrap(value): java.lang.String)
      )(_.body)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.InspectionDataResponse.ReadOnly =
    zio.aws.sfn.model.InspectionDataResponse.wrap(buildAwsValue())
}
object InspectionDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.InspectionDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.InspectionDataResponse =
      zio.aws.sfn.model.InspectionDataResponse(
        protocol.map(value => value),
        statusCode.map(value => value),
        statusMessage.map(value => value),
        headers.map(value => value),
        body.map(value => value)
      )
    def protocol: Optional[HTTPProtocol]
    def statusCode: Optional[HTTPStatusCode]
    def statusMessage: Optional[HTTPStatusMessage]
    def headers: Optional[HTTPHeaders]
    def body: Optional[HTTPBody]
    def getProtocol: ZIO[Any, AwsError, HTTPProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getStatusCode: ZIO[Any, AwsError, HTTPStatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getStatusMessage: ZIO[Any, AwsError, HTTPStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getHeaders: ZIO[Any, AwsError, HTTPHeaders] =
      AwsError.unwrapOptionField("headers", headers)
    def getBody: ZIO[Any, AwsError, HTTPBody] =
      AwsError.unwrapOptionField("body", body)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.InspectionDataResponse
  ) extends zio.aws.sfn.model.InspectionDataResponse.ReadOnly {
    override val protocol: Optional[HTTPProtocol] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => zio.aws.sfn.model.primitives.HTTPProtocol(value))
    override val statusCode: Optional[HTTPStatusCode] = zio.aws.core.internal
      .optionalFromNullable(impl.statusCode())
      .map(value => zio.aws.sfn.model.primitives.HTTPStatusCode(value))
    override val statusMessage: Optional[HTTPStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value => zio.aws.sfn.model.primitives.HTTPStatusMessage(value))
    override val headers: Optional[HTTPHeaders] = zio.aws.core.internal
      .optionalFromNullable(impl.headers())
      .map(value => zio.aws.sfn.model.primitives.HTTPHeaders(value))
    override val body: Optional[HTTPBody] = zio.aws.core.internal
      .optionalFromNullable(impl.body())
      .map(value => zio.aws.sfn.model.primitives.HTTPBody(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.InspectionDataResponse
  ): zio.aws.sfn.model.InspectionDataResponse.ReadOnly = new Wrapper(impl)
}
