package zio.aws.sfn.model
import scala.jdk.CollectionConverters._
sealed trait InspectionLevel {
  def unwrap: software.amazon.awssdk.services.sfn.model.InspectionLevel
}
object InspectionLevel {
  def wrap(
      value: software.amazon.awssdk.services.sfn.model.InspectionLevel
  ): zio.aws.sfn.model.InspectionLevel = value match {
    case software.amazon.awssdk.services.sfn.model.InspectionLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sfn.model.InspectionLevel.INFO =>
      val r = INFO
      r
    case software.amazon.awssdk.services.sfn.model.InspectionLevel.DEBUG =>
      val r = DEBUG
      r
    case software.amazon.awssdk.services.sfn.model.InspectionLevel.TRACE =>
      val r = TRACE
      r
  }
  case object unknownToSdkVersion extends zio.aws.sfn.model.InspectionLevel {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.InspectionLevel =
      software.amazon.awssdk.services.sfn.model.InspectionLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object INFO extends zio.aws.sfn.model.InspectionLevel {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.InspectionLevel =
      software.amazon.awssdk.services.sfn.model.InspectionLevel.INFO
  }
  case object DEBUG extends zio.aws.sfn.model.InspectionLevel {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.InspectionLevel =
      software.amazon.awssdk.services.sfn.model.InspectionLevel.DEBUG
  }
  case object TRACE extends zio.aws.sfn.model.InspectionLevel {
    override def unwrap
        : software.amazon.awssdk.services.sfn.model.InspectionLevel =
      software.amazon.awssdk.services.sfn.model.InspectionLevel.TRACE
  }
}
