package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{TimeoutInSeconds, SensitiveData, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LambdaFunctionScheduledEventDetails(
    resource: Arn,
    input: Optional[SensitiveData] = Optional.Absent,
    inputDetails: Optional[zio.aws.sfn.model.HistoryEventExecutionDataDetails] =
      Optional.Absent,
    timeoutInSeconds: Optional[TimeoutInSeconds] = Optional.Absent,
    taskCredentials: Optional[zio.aws.sfn.model.TaskCredentials] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.LambdaFunctionScheduledEventDetails = {
    import LambdaFunctionScheduledEventDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.LambdaFunctionScheduledEventDetails
      .builder()
      .resource(Arn.unwrap(resource): java.lang.String)
      .optionallyWith(
        input.map(value => SensitiveData.unwrap(value): java.lang.String)
      )(_.input)
      .optionallyWith(inputDetails.map(value => value.buildAwsValue()))(
        _.inputDetails
      )
      .optionallyWith(
        timeoutInSeconds.map(value =>
          TimeoutInSeconds.unwrap(value): java.lang.Long
        )
      )(_.timeoutInSeconds)
      .optionallyWith(taskCredentials.map(value => value.buildAwsValue()))(
        _.taskCredentials
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sfn.model.LambdaFunctionScheduledEventDetails.ReadOnly =
    zio.aws.sfn.model.LambdaFunctionScheduledEventDetails.wrap(buildAwsValue())
}
object LambdaFunctionScheduledEventDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.LambdaFunctionScheduledEventDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.LambdaFunctionScheduledEventDetails =
      zio.aws.sfn.model.LambdaFunctionScheduledEventDetails(
        resource,
        input.map(value => value),
        inputDetails.map(value => value.asEditable),
        timeoutInSeconds.map(value => value),
        taskCredentials.map(value => value.asEditable)
      )
    def resource: Arn
    def input: Optional[SensitiveData]
    def inputDetails
        : Optional[zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly]
    def timeoutInSeconds: Optional[TimeoutInSeconds]
    def taskCredentials: Optional[zio.aws.sfn.model.TaskCredentials.ReadOnly]
    def getResource: ZIO[Any, Nothing, Arn] = ZIO.succeed(resource)
    def getInput: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("input", input)
    def getInputDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly
    ] = AwsError.unwrapOptionField("inputDetails", inputDetails)
    def getTimeoutInSeconds: ZIO[Any, AwsError, TimeoutInSeconds] =
      AwsError.unwrapOptionField("timeoutInSeconds", timeoutInSeconds)
    def getTaskCredentials
        : ZIO[Any, AwsError, zio.aws.sfn.model.TaskCredentials.ReadOnly] =
      AwsError.unwrapOptionField("taskCredentials", taskCredentials)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.LambdaFunctionScheduledEventDetails
  ) extends zio.aws.sfn.model.LambdaFunctionScheduledEventDetails.ReadOnly {
    override val resource: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.resource())
    override val input: Optional[SensitiveData] = zio.aws.core.internal
      .optionalFromNullable(impl.input())
      .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val inputDetails: Optional[
      zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputDetails())
      .map(value =>
        zio.aws.sfn.model.HistoryEventExecutionDataDetails.wrap(value)
      )
    override val timeoutInSeconds: Optional[TimeoutInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutInSeconds())
        .map(value => zio.aws.sfn.model.primitives.TimeoutInSeconds(value))
    override val taskCredentials
        : Optional[zio.aws.sfn.model.TaskCredentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskCredentials())
        .map(value => zio.aws.sfn.model.TaskCredentials.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.LambdaFunctionScheduledEventDetails
  ): zio.aws.sfn.model.LambdaFunctionScheduledEventDetails.ReadOnly =
    new Wrapper(impl)
}
