package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.PageToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListActivitiesResponse(
    activities: Iterable[zio.aws.sfn.model.ActivityListItem],
    nextToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ListActivitiesResponse = {
    import ListActivitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ListActivitiesResponse
      .builder()
      .activities(activities.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.ListActivitiesResponse.ReadOnly =
    zio.aws.sfn.model.ListActivitiesResponse.wrap(buildAwsValue())
}
object ListActivitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ListActivitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ListActivitiesResponse =
      zio.aws.sfn.model.ListActivitiesResponse(
        activities.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def activities: List[zio.aws.sfn.model.ActivityListItem.ReadOnly]
    def nextToken: Optional[PageToken]
    def getActivities
        : ZIO[Any, Nothing, List[zio.aws.sfn.model.ActivityListItem.ReadOnly]] =
      ZIO.succeed(activities)
    def getNextToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ListActivitiesResponse
  ) extends zio.aws.sfn.model.ListActivitiesResponse.ReadOnly {
    override val activities: List[zio.aws.sfn.model.ActivityListItem.ReadOnly] =
      impl
        .activities()
        .asScala
        .map { item =>
          zio.aws.sfn.model.ActivityListItem.wrap(item)
        }
        .toList
    override val nextToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sfn.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ListActivitiesResponse
  ): zio.aws.sfn.model.ListActivitiesResponse.ReadOnly = new Wrapper(impl)
}
