package zio.aws.sfn.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{
  LongArn,
  ListExecutionsPageToken,
  PageSize,
  Arn
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListExecutionsRequest(
    stateMachineArn: Optional[Arn] = Optional.Absent,
    statusFilter: Optional[zio.aws.sfn.model.ExecutionStatus] = Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent,
    nextToken: Optional[ListExecutionsPageToken] = Optional.Absent,
    mapRunArn: Optional[LongArn] = Optional.Absent,
    redriveFilter: Optional[zio.aws.sfn.model.ExecutionRedriveFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ListExecutionsRequest = {
    import ListExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ListExecutionsRequest
      .builder()
      .optionallyWith(
        stateMachineArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.stateMachineArn)
      .optionallyWith(statusFilter.map(value => value.unwrap))(_.statusFilter)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value =>
          ListExecutionsPageToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        mapRunArn.map(value => LongArn.unwrap(value): java.lang.String)
      )(_.mapRunArn)
      .optionallyWith(redriveFilter.map(value => value.unwrap))(_.redriveFilter)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.ListExecutionsRequest.ReadOnly =
    zio.aws.sfn.model.ListExecutionsRequest.wrap(buildAwsValue())
}
object ListExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ListExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ListExecutionsRequest =
      zio.aws.sfn.model.ListExecutionsRequest(
        stateMachineArn.map(value => value),
        statusFilter.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        mapRunArn.map(value => value),
        redriveFilter.map(value => value)
      )
    def stateMachineArn: Optional[Arn]
    def statusFilter: Optional[zio.aws.sfn.model.ExecutionStatus]
    def maxResults: Optional[PageSize]
    def nextToken: Optional[ListExecutionsPageToken]
    def mapRunArn: Optional[LongArn]
    def redriveFilter: Optional[zio.aws.sfn.model.ExecutionRedriveFilter]
    def getStateMachineArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("stateMachineArn", stateMachineArn)
    def getStatusFilter: ZIO[Any, AwsError, zio.aws.sfn.model.ExecutionStatus] =
      AwsError.unwrapOptionField("statusFilter", statusFilter)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, ListExecutionsPageToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMapRunArn: ZIO[Any, AwsError, LongArn] =
      AwsError.unwrapOptionField("mapRunArn", mapRunArn)
    def getRedriveFilter
        : ZIO[Any, AwsError, zio.aws.sfn.model.ExecutionRedriveFilter] =
      AwsError.unwrapOptionField("redriveFilter", redriveFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ListExecutionsRequest
  ) extends zio.aws.sfn.model.ListExecutionsRequest.ReadOnly {
    override val stateMachineArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.stateMachineArn())
      .map(value => zio.aws.sfn.model.primitives.Arn(value))
    override val statusFilter: Optional[zio.aws.sfn.model.ExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusFilter())
        .map(value => zio.aws.sfn.model.ExecutionStatus.wrap(value))
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sfn.model.primitives.PageSize(value))
    override val nextToken: Optional[ListExecutionsPageToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.sfn.model.primitives.ListExecutionsPageToken(value)
        )
    override val mapRunArn: Optional[LongArn] = zio.aws.core.internal
      .optionalFromNullable(impl.mapRunArn())
      .map(value => zio.aws.sfn.model.primitives.LongArn(value))
    override val redriveFilter
        : Optional[zio.aws.sfn.model.ExecutionRedriveFilter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.redriveFilter())
        .map(value => zio.aws.sfn.model.ExecutionRedriveFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ListExecutionsRequest
  ): zio.aws.sfn.model.ListExecutionsRequest.ReadOnly = new Wrapper(impl)
}
