package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.ListExecutionsPageToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListExecutionsResponse(
    executions: Iterable[zio.aws.sfn.model.ExecutionListItem],
    nextToken: Optional[ListExecutionsPageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ListExecutionsResponse = {
    import ListExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ListExecutionsResponse
      .builder()
      .executions(executions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value =>
          ListExecutionsPageToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.ListExecutionsResponse.ReadOnly =
    zio.aws.sfn.model.ListExecutionsResponse.wrap(buildAwsValue())
}
object ListExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ListExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ListExecutionsResponse =
      zio.aws.sfn.model.ListExecutionsResponse(
        executions.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def executions: List[zio.aws.sfn.model.ExecutionListItem.ReadOnly]
    def nextToken: Optional[ListExecutionsPageToken]
    def getExecutions: ZIO[Any, Nothing, List[
      zio.aws.sfn.model.ExecutionListItem.ReadOnly
    ]] = ZIO.succeed(executions)
    def getNextToken: ZIO[Any, AwsError, ListExecutionsPageToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ListExecutionsResponse
  ) extends zio.aws.sfn.model.ListExecutionsResponse.ReadOnly {
    override val executions
        : List[zio.aws.sfn.model.ExecutionListItem.ReadOnly] = impl
      .executions()
      .asScala
      .map { item =>
        zio.aws.sfn.model.ExecutionListItem.wrap(item)
      }
      .toList
    override val nextToken: Optional[ListExecutionsPageToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.sfn.model.primitives.ListExecutionsPageToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ListExecutionsResponse
  ): zio.aws.sfn.model.ListExecutionsResponse.ReadOnly = new Wrapper(impl)
}
